/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.util;

import com.transjam.util.Meeting;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Schedule {
    Hashtable meetings = new Hashtable();

    void addMeeting(Meeting meeting) {
        this.meetings.put(meeting.getDate(), meeting);
    }

    Meeting getMeeting(Date when) {
        return (Meeting)this.meetings.get(when);
    }

    public synchronized Meeting addMeeting(Date when) {
        Meeting meeting = this.getMeeting(when);
        if (meeting == null) {
            meeting = new Meeting(when);
        }
        this.addMeeting(meeting);
        return meeting;
    }

    public static Date truncateDate(Date when, int minutes) {
        long intervalMsec = (long)minutes * 60000L;
        long newUTC = when.getTime();
        long q = newUTC / intervalMsec;
        newUTC = q * intervalMsec;
        return new Date(newUTC);
    }

    public synchronized void joinMeeting(Date when) {
        Meeting meeting = this.addMeeting(when);
        meeting.setCount(meeting.getCount() + 1);
    }

    public synchronized void removeStaleMeetings(Date when) {
        Vector<Meeting> removeThese = new Vector<Meeting>();
        Enumeration allMeetings = this.getMeetings();
        while (allMeetings.hasMoreElements()) {
            Meeting meeting = (Meeting)allMeetings.nextElement();
            if (!meeting.getDate().before(when)) continue;
            removeThese.addElement(meeting);
        }
        Enumeration oldMeetings = removeThese.elements();
        while (oldMeetings.hasMoreElements()) {
            Meeting meeting = (Meeting)oldMeetings.nextElement();
            this.meetings.remove(meeting.getDate());
        }
    }

    public Enumeration getMeetings() {
        return this.meetings.elements();
    }

    void print() {
        System.out.println("Schedule -----------");
        Enumeration allMeetings = this.getMeetings();
        while (allMeetings.hasMoreElements()) {
            Meeting meeting = (Meeting)allMeetings.nextElement();
            System.out.println(meeting);
        }
    }

    void test() {
        Date now = new Date();
        Date t1 = Schedule.truncateDate(now, 60);
        this.addMeeting(t1);
        Meeting meeting = this.getMeeting(t1);
        this.print();
        meeting.setCount(5);
        this.print();
        Date t2 = new Date(t1.getTime() + 0x6DDD00L);
        this.addMeeting(t2);
        this.print();
        Date t3 = new Date(t1.getTime() + 10800000L);
        this.addMeeting(t3);
        this.print();
        this.removeStaleMeetings(t2);
        this.print();
    }

    public static void main(String[] args) {
        System.out.println("Test Schedule");
        new Schedule().test();
    }
}

