/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.server;

import com.transjam.server.ClientTracker;
import java.io.IOException;
import java.util.Vector;

public class Thing {
    private String name;
    private String contents;
    private ClientTracker owner;
    private Vector pending;

    public Thing(String name) {
        this.name = name;
        this.pending = new Vector();
    }

    public ClientTracker getOwner() {
        return this.owner;
    }

    public synchronized boolean lock(ClientTracker client) throws IOException {
        if (this.owner != null) {
            if (this.pending.size() == 0) {
                this.owner.lockThing(this.name);
            }
            this.pending.addElement(client);
            return false;
        }
        this.owner = client;
        return true;
    }

    public synchronized ClientTracker denyLock() throws IOException {
        ClientTracker rejectee = null;
        if (this.pending.size() > 0) {
            rejectee = (ClientTracker)this.pending.firstElement();
            this.pending.removeElementAt(0);
            rejectee.denyLock(this.name);
        }
        return rejectee;
    }

    public synchronized ClientTracker processPendingClient() throws IOException {
        ClientTracker nextOwner = null;
        if (this.pending.size() > 0) {
            nextOwner = (ClientTracker)this.pending.firstElement();
            this.owner.lockThing(this.name);
        }
        return this.owner;
    }

    public synchronized ClientTracker unlock(ClientTracker client) {
        if (this.owner == client) {
            if (this.pending.size() > 0) {
                this.owner = (ClientTracker)this.pending.firstElement();
                this.pending.removeElementAt(0);
            } else {
                this.owner = null;
            }
            return this.owner;
        }
        return null;
    }

    public boolean isLocked() {
        return this.owner != null;
    }

    public boolean isLockedBy(ClientTracker client) {
        return this.owner == client;
    }

    public String getName() {
        return this.name;
    }

    public String getContents() {
        return this.contents;
    }

    public synchronized boolean setContents(ClientTracker client, String contents) {
        if (this.isLockedBy(client)) {
            this.contents = contents;
            return true;
        }
        return false;
    }
}

