/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.server;

import com.transjam.server.ClientTracker;
import com.transjam.util.Meeting;
import com.transjam.util.Schedule;
import com.transjam.util.XMLListener;
import com.transjam.util.XMLReader;
import com.transjam.util.XMLWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class ScheduleManager
extends Schedule
implements XMLListener {
    @Override
    public void beginElement(String tag, Hashtable attributes, boolean ifEmpty) {
        if (tag.equals("meeting")) {
            Date now;
            int count = XMLReader.getAttribute(attributes, "count", 0);
            long utc = XMLReader.getAttribute(attributes, "time", 0L);
            Date when = new Date(utc);
            if (when.after(now = new Date())) {
                Meeting meeting = this.addMeeting(when);
                meeting.setCount(count);
            } else {
                System.out.println("Old meeting discarded on load = " + when);
                System.out.println("now = " + now);
            }
        }
    }

    @Override
    public void foundContent(String content) {
    }

    @Override
    public void endElement(String tag) {
    }

    public void save(XMLWriter writer) {
        Date now = new Date();
        Enumeration enumer = this.getMeetings();
        while (enumer.hasMoreElements()) {
            Meeting meeting = (Meeting)enumer.nextElement();
            writer.beginElement("meeting");
            writer.writeAttribute("time", meeting.getDate().getTime());
            writer.writeAttribute("count", meeting.getCount());
            writer.endElement();
        }
    }

    public void requestMeetingList(ClientTracker client) throws IOException {
        this.removeStaleMeetings(new Date());
        Enumeration enumer = this.getMeetings();
        while (enumer.hasMoreElements()) {
            Meeting meeting = (Meeting)enumer.nextElement();
            client.addMeeting(meeting.getDate(), meeting.getCount());
        }
        client.endList();
    }
}

