/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.server;

import com.transjam.server.ClientMessage;
import com.transjam.server.MessageQueue;
import com.transjam.server.Room;
import com.transjam.server.Server;
import com.transjam.server.Thing;
import com.transjam.util.ClientBase;
import com.transjam.util.ClientLocation;
import com.transjam.util.DebugLog;
import com.transjam.util.TextTools;
import com.transjam.util.TransjamMessage;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;

public class ClientTracker
extends ClientBase {
    private Room room = null;
    private long loginTime;
    private boolean encounteredOthers = false;
    private WriteThread writeThread;
    private long lastMessageTime = System.currentTimeMillis();
    private ClientLocation location;
    private boolean locationRequestPending = false;
    private int subscriptions;
    public static final int SUBSCRIBE_ROOMS = 1;
    public static final int SUBSCRIBE_USERS = 2;
    public static final int SUBSCRIBE_THINGS = 4;
    public static final int SUBSCRIBE_LOCATIONS = 8;
    Server server;

    public ClientTracker(Server server, int id, Socket socket, int timeoutMSec) throws IOException {
        this.server = server;
        this.writeThread = new WriteThread();
        this.setUserID(id);
        this.setSocket(socket, timeoutMSec);
        this.loginTime = System.currentTimeMillis();
    }

    @Override
    public void start() {
        this.writeThread.start();
        super.start();
    }

    @Override
    public void stop() {
        this.writeThread.abort();
        super.stop();
    }

    public void exitWhenDone() {
        this.writeThread.exitWhenDone();
    }

    protected boolean hasReceivedMessageSince(long time) {
        return time - this.lastMessageTime <= 0L;
    }

    protected long getLoginTime() {
        return this.loginTime;
    }

    protected boolean getEncountered() {
        return this.encounteredOthers;
    }

    protected void setEncountered(boolean flag) {
        this.encounteredOthers = flag;
    }

    void setSubscription(int mask) {
        this.subscriptions |= mask;
    }

    void clearSubscription(int mask) {
        this.subscriptions &= ~mask;
    }

    boolean isSubscribed(int mask) {
        return (this.subscriptions & mask) != 0;
    }

    void setRoom(Room room) throws IOException {
        this.leaveCurrentRoom();
        this.room = room;
    }

    Room getRoom() {
        return this.room;
    }

    void leaveCurrentRoom() throws IOException {
        if (this.room != null) {
            this.room.removeClient(this);
            this.room = null;
        }
    }

    public void cleanup() {
        this.debugln(117, "ClientTracker.cleanup()");
        if (this.room != null) {
            try {
                this.leaveCurrentRoom();
            }
            catch (IOException le) {
                this.debugln(117, "ClientTracker caught " + le);
            }
        }
        this.exitWhenWriteDone();
        this.server.logoutClient(this);
        this.setActive(false);
    }

    void grantLogin() throws IOException {
        this.write(this.writer.grantLogin(this.getUserID()));
    }

    void denyLogin(String msg) throws IOException {
        this.write(this.writer.denyLogin(msg));
    }

    void denyThing(String name) throws IOException {
        this.write(this.writer.denyThing(name));
    }

    void denyRoom(String name) throws IOException {
        this.write(this.writer.denyRoom(name));
    }

    void noThing(String name) throws IOException {
        this.write(this.writer.noThing(name));
    }

    void grantLock(String name, int uid) throws IOException {
        this.write(this.writer.grantLock(name, uid));
    }

    void addRoom(Room child) throws IOException {
        this.write(this.writer.addRoom(child.getName(), child.getMaxClients(), child.getNumClients()));
    }

    void addUser(ClientTracker other) throws IOException {
        this.write(this.writer.addUser(other.getName(), other.getUserID()));
    }

    void addThing(Thing thing) throws IOException {
        this.write(this.writer.addThing(thing.getName()));
    }

    void endList() throws IOException {
        this.write(this.writer.endList());
    }

    void sendTime() throws IOException {
        this.write(this.writer.sendTime(System.currentTimeMillis()));
    }

    public void processMessage(TransjamMessage message) throws IOException {
        String debugText = "got: " + message;
        if (message.command.equals("reqecho")) {
            this.replyEcho(message.content);
            this.debugln(104, debugText);
            return;
        }
        if (message.command.equals("echo")) {
            this.debugln(104, debugText);
            return;
        }
        this.debugln(114, debugText);
        if (message.command.equals("sync")) {
            this.sendSync(message.content);
        } else if (message.command.equals("modifything")) {
            String thingName = message.get("name");
            this.room.modifyThing(this, thingName, message.content);
        } else if (message.command.equals("chat")) {
            int flags = message.get("flags", 0);
            this.debugln(99, "Chat: " + this.room.getName() + ", " + message.content);
            this.room.sendChat(this, flags, message.content);
        } else if (message.command.equals("sendall")) {
            this.room.sendAll(this, message.content);
        } else if (message.command.equals("sendothers")) {
            this.room.sendOthers(this, message.content);
        } else if (message.command.equals("senduser")) {
            int targetID = message.get("uid", 0);
            this.room.sendUser(this, targetID, message.content);
        } else if (message.command.equals("sendself")) {
            this.sendSelf(message.content);
        } else if (message.command.equals("locknewthing")) {
            String thingName = message.get("name");
            this.room.lockNewThing(this, thingName, message.content);
        } else if (message.command.equals("lockoldthing")) {
            String thingName = message.get("name");
            this.room.lockOldThing(this, thingName);
        } else if (message.command.equals("lockthing")) {
            String thingName = message.get("name");
            this.room.lockThing(this, thingName);
        } else if (message.command.equals("unlockthing")) {
            String thingName = message.get("name");
            this.room.unlockThing(this, thingName);
        } else if (message.command.equals("denylock")) {
            String thingName = message.get("name");
            this.room.denyLock(this, thingName);
        } else if (message.command.equals("grantlock")) {
            String thingName = message.get("name");
            this.room.unlockThing(this, thingName);
        } else if (message.command.equals("deletething")) {
            String thingName = message.get("name");
            this.room.deleteThing(this, thingName);
        } else if (message.command.equals("validate")) {
            if (!this.checkValidationMessage(message.content)) {
                this.closeSocket("Validation failed");
            } else {
                this.requestValidation();
            }
        } else if (message.command.equals("joinnewroom")) {
            int level = message.get("level", this.room.getLevel());
            int maxClients = message.get("maxclients", 0);
            int flags = message.get("flags", 0);
            String safeName = TextTools.makeSafe(message.content);
            if (level != this.room.getLevel()) {
                this.denyRoom(safeName);
            } else {
                this.room.joinNewRoom(this, safeName, maxClients, flags);
            }
        } else if (message.command.equals("joinroom")) {
            int level = message.get("level", this.room.getLevel());
            int maxClients = message.get("maxclients", 0);
            int flags = message.get("flags", 0);
            String safeName = TextTools.makeSafe(message.content);
            if (level != this.room.getLevel()) {
                this.denyRoom(safeName);
            } else {
                this.room.joinRoom(this, safeName, maxClients, flags);
            }
        } else if (message.command.equals("joinoldroom")) {
            int level = message.get("level", this.room.getLevel());
            String safeName = TextTools.makeSafe(message.content);
            if (level != this.room.getLevel()) {
                this.denyRoom(safeName);
            } else {
                this.room.joinOldRoom(this, safeName);
            }
        } else if (message.command.equals("leaveroom")) {
            int serverLevel;
            int clientLevel = message.get("level", -1);
            if (clientLevel == (serverLevel = this.room.getLevel())) {
                Room parent = this.room.getParent();
                if (parent != null) {
                    parent.addClient(this);
                }
            } else {
                System.err.println("WARNING - got CMD_C_LEAVE_ROOM but clientLevel = " + clientLevel + ", serverLevel = " + serverLevel);
            }
        } else if (message.command.equals("listrooms")) {
            this.room.sendRoomList(this);
        } else if (message.command.equals("listusers")) {
            this.room.sendUserList(this);
        } else if (message.command.equals("requserxy")) {
            this.room.requestUserLocations(this);
        } else if (message.command.equals("userxy")) {
            this.setLocation(message);
            this.room.sendUserLocation(this);
        } else if (message.command.equals("listthings")) {
            this.room.sendThingList(this);
        } else if (message.command.equals("reqtime")) {
            this.sendTime();
        } else if (message.command.equals("reqschedule")) {
            this.room.requestMeetingList(this);
        } else if (message.command.equals("joinmeeting")) {
            int minutesUTC = message.get("mutc", 0);
            Date when = new Date((long)minutesUTC * 60000L);
            this.room.joinMeeting(this, when);
        } else if (message.command.equals("requestlogin")) {
            String safeName = TextTools.makeSafe(message.content);
            this.setName(safeName);
            String reason = this.server.requestClientLogin(this);
            if (reason == null) {
                this.grantLogin();
            } else {
                this.denyLogin(reason);
                this.exitWhenDone();
            }
        } else if (message.command.equals("logout")) {
            DebugLog.debugln(117, "CMD_CS_LOGOUT " + debugText);
            this.beginGracefulShutdown();
        } else {
            throw new RuntimeException("Unrecognized message = " + message);
        }
    }

    private void setLocation(TransjamMessage message) {
        this.location = new ClientLocation();
        this.location.latitude = message.get("lat", 0.0);
        this.location.longitude = message.get("lon", 0.0);
    }

    @Override
    public void gotTimeout(int numTimeouts) throws IOException {
        if (numTimeouts != 1) {
            throw new IOException("Client not responding.");
        }
        ClientMessage cmsg = new ClientMessage(this, 3);
        this.server.postMessage(cmsg);
    }

    @Override
    public void gotThrowable(Throwable exc) {
        ClientMessage cmsg = new ClientMessage(this, exc);
        this.server.postMessage(cmsg);
    }

    @Override
    public void gotStart() {
        ClientMessage cmsg = new ClientMessage(this, 0);
        this.server.postMessage(cmsg);
    }

    @Override
    public void gotStop() {
        ClientMessage cmsg = new ClientMessage(this, 4);
        this.server.postMessage(cmsg);
    }

    @Override
    public void gotMessage(TransjamMessage message) {
        ClientMessage cmsg = new ClientMessage(this, message);
        this.server.postMessage(cmsg);
        this.lastMessageTime = System.currentTimeMillis();
    }

    @Override
    public void write(String text) throws IOException {
        this.writeThread.post(text);
    }

    public void exitWhenWriteDone() {
        this.writeThread.exitWhenDone();
    }

    public ClientLocation getLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (!this.locationRequestPending) {
            this.locationRequestPending = true;
            Server.requestLocation(this);
        }
        return null;
    }

    public void setLocation(ClientLocation location) {
        this.location = location;
    }

    public void sendLocation(ClientTracker other) throws IOException {
        this.write(this.writer.sendLocation(other.getUserID(), other.getLocation()));
    }

    class WriteThread
    extends Thread {
        private MessageQueue queue = new MessageQueue();
        private volatile boolean go = true;
        private boolean exiting = false;

        WriteThread() {
        }

        void abort() {
            this.go = false;
            this.interrupt();
        }

        public void exitWhenDone() {
            this.exiting = true;
            this.interrupt();
        }

        void post(String text) throws IOException {
            if (this.go) {
                this.queue.send(text);
            }
        }

        @Override
        public void run() {
            while (this.go) {
                try {
                    if (this.exiting && !this.queue.isMessageAvailable()) {
                        this.go = false;
                        break;
                    }
                    String text = (String)this.queue.waitForMessage();
                    try {
                        ClientTracker.this.writeSocket(text);
                    }
                    catch (IOException e) {
                        DebugLog.debugln(String.valueOf(this.getName()) + "'s ClientTracker WriteThread writeSocket failed: " + e);
                        this.go = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                ClientTracker.this.getSocket().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DebugLog.debugln(String.valueOf(this.getName()) + "'s ClientTracker WriteThread returning from run().");
        }
    }
}

