/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.util.StreamRecorder;
import com.softsynth.jsyn.util.WAVFileWriter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

class WAVRecorder {
    StreamRecorder recorder;
    OutputStream outStream;
    WAVFileWriter waveWriter;
    public SynthInput input;
    static final int FRAMES_PER_BUFFER = 8192;
    RandomAccessFile rfile;

    WAVRecorder() {
    }

    void open(String fileName, int numChannels, int sampleRate) {
        try {
            this.rfile = new RandomAccessFile(fileName, "rw");
            this.waveWriter = new WAVFileWriter(this.rfile);
            this.outStream = new BufferedOutputStream(this.waveWriter);
            System.out.println("Recording to file " + fileName);
            this.waveWriter.writeHeader(numChannels, sampleRate);
            this.recorder = new StreamRecorder(this.outStream, 8192, 4, numChannels);
            this.input = this.recorder.input;
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (SecurityException e) {
            System.err.println(e);
        }
    }

    void start() {
        if (this.recorder != null) {
            this.recorder.start(Synth.getTickCount());
        }
    }

    void stop() {
        if (this.recorder != null) {
            this.recorder.stop(Synth.getTickCount());
        }
    }

    void close() {
        try {
            if (this.outStream != null) {
                this.outStream.flush();
                this.waveWriter.fixSizes();
                this.outStream.flush();
                this.outStream.close();
                this.rfile.close();
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (SecurityException e) {
            System.err.println(e);
        }
    }
}

