/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.DrumSynth;
import com.transjam.drumbox.SongModel;
import com.transjam.drumbox.TrackModel;
import com.transjam.drumbox.TrackPlayer;
import java.util.Observable;

public class SongPlayer
implements Runnable {
    private SongModel songModel;
    private DrumSynth synth;
    private TrackPlayer[] trackPlayers;
    private Thread thread;
    private volatile boolean go;
    private boolean done = true;
    private int beatIndex;
    private int numSolos = 0;

    public SongPlayer(SongModel songModel, DrumSynth synth) {
        this.songModel = songModel;
        this.synth = synth;
        int numTracks = songModel.getNumTracks();
        this.trackPlayers = new TrackPlayer[numTracks];
        int i = 0;
        while (i < numTracks) {
            TrackModel trackModel = songModel.getTrack(i);
            this.trackPlayers[i] = new TrackPlayer(this, trackModel, synth);
            ++i;
        }
    }

    public TrackPlayer getTrackPlayer(int trackIndex) {
        return this.trackPlayers[trackIndex];
    }

    public void start() {
        this.stop();
        this.thread = new Thread((Runnable)this, "SongPlayer");
        this.go = true;
        this.done = false;
        int i = 0;
        while (i < this.trackPlayers.length) {
            this.trackPlayers[i].start();
            ++i;
        }
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.go = false;
        int i = 0;
        while (i < this.trackPlayers.length) {
            this.trackPlayers[i].stop();
            ++i;
        }
        if (this.thread != null) {
            try {
                Thread thread = this.thread;
                synchronized (thread) {
                    while (!this.done) {
                        this.thread.wait(5000L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            double nextTime = this.synth.getTime();
            this.beatIndex = 0;
            while (this.go) {
                double secondsPerBeat = 60.0 / this.songModel.getBeatsPerMinute();
                int i = 0;
                while (i < this.trackPlayers.length) {
                    this.trackPlayers[i].masterBeat(this.beatIndex, nextTime, secondsPerBeat);
                    ++i;
                }
                nextTime += secondsPerBeat;
                try {
                    this.synth.sleepUntilTime(nextTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.beatIndex;
            }
        }
        catch (Throwable throwable) {
            Thread thread = this.thread;
            synchronized (thread) {
                this.done = true;
                this.thread.notifyAll();
            }
            throw throwable;
        }
        Thread thread = this.thread;
        synchronized (thread) {
            this.done = true;
            this.thread.notifyAll();
        }
    }

    public void update(Observable o, Object arg) {
    }

    synchronized void setTrackSolo(TrackPlayer trackPlayer, boolean isSolo) {
        if (isSolo) {
            if (this.numSolos > 0) {
                trackPlayer.setMute(false);
            } else {
                int i = 0;
                while (i < this.trackPlayers.length) {
                    this.trackPlayers[i].setMute(this.trackPlayers[i] != trackPlayer);
                    ++i;
                }
            }
            ++this.numSolos;
        } else {
            if (this.numSolos > 1) {
                trackPlayer.setMute(true);
            } else {
                int i = 0;
                while (i < this.trackPlayers.length) {
                    this.trackPlayers[i].setMute(false);
                    ++i;
                }
            }
            --this.numSolos;
        }
    }
}

