/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.drumbox;

import com.transjam.drumbox.DrumBox;
import com.transjam.drumbox.DrumSynth;
import com.transjam.drumbox.SongModel;
import com.transjam.drumbox.SongPlayer;
import com.transjam.drumbox.TrackDelegate;
import com.transjam.drumbox.TrackModel;
import com.transjam.drumbox.TrackPlayer;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;

public class SongDelegate
extends Panel
implements Observer {
    private SongModel songModel;
    private SongPlayer songPlayer;
    private DrumSynth drumSynth;
    private TrackDelegate[] trackDelegates;
    private Panel controlPanel;
    private int currentVolumeToSet = 2;
    private int previousMaxTime;
    private TextField bpmText;
    private Choice tuningChoice;
    private Choice keyChoice;
    private String[] noteNames = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private GridBagConstraints constraint;
    private GridBagLayout gridbag;
    public static final int NUM_MELODIC_TRACKS = 2;
    public static final double MIN_BPM = 20.0;
    public static final double MAX_BPM = 400.0;

    public SongDelegate(SongModel pSongModel, SongPlayer pSongPlayer, DrumSynth pDrumSynth) {
        this.songModel = pSongModel;
        this.drumSynth = pDrumSynth;
        this.songPlayer = pSongPlayer;
        int numTracks = this.songModel.getNumTracks();
        this.trackDelegates = new TrackDelegate[numTracks];
        this.setLayout(new BorderLayout());
        this.gridbag = new GridBagLayout();
        Panel trackPanel = new Panel(this.gridbag);
        this.add("Center", trackPanel);
        this.constraint = new GridBagConstraints();
        this.constraint.insets = new Insets(2, 2, 2, 2);
        this.constraint.fill = 2;
        this.constraint.gridy = -1;
        this.constraint.gridx = 0;
        int i = 0;
        while (i < numTracks) {
            TrackModel trackModel = this.songModel.getTrack(i);
            int insIndex = i % (numTracks - 2);
            this.trackDelegates[i] = new TrackDelegate(insIndex, this, trackModel, this.songPlayer.getTrackPlayer(i), this.drumSynth);
            this.gridbag.setConstraints(this.trackDelegates[i], this.constraint);
            trackPanel.add(this.trackDelegates[i]);
            this.trackDelegates[i].setBackground(DrumBox.COLOR_TRACK);
            ++i;
        }
        this.controlPanel = new Panel();
        this.add("South", this.controlPanel);
        Panel synthPanel = this.drumSynth.getPanel();
        if (synthPanel != null) {
            this.controlPanel.add(synthPanel);
        }
        this.controlPanel.add(this.setupVolumeBoxes());
        this.tuningChoice = this.setupTuningChoice();
        this.controlPanel.add(this.tuningChoice);
        this.keyChoice = this.setupKeyChoice();
        this.controlPanel.add(this.keyChoice);
        this.controlPanel.add(new Label("BPM"));
        this.bpmText = new TextField(4);
        this.controlPanel.add(this.bpmText);
        this.bpmText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double bpm = Double.valueOf(SongDelegate.this.bpmText.getText());
                if (bpm < 20.0) {
                    bpm = 20.0;
                } else if (bpm > 400.0) {
                    bpm = 400.0;
                }
                SongDelegate.this.songModel.setBeatsPerMinute(bpm);
            }
        });
        this.songModel.addObserver(this);
        this.songModel.setBeatsPerMinute(this.songModel.getBeatsPerMinute());
        this.validate();
    }

    public TrackDelegate getTrack(int trackIndex) {
        return this.trackDelegates[trackIndex];
    }

    public Panel getControlPanel() {
        return this.controlPanel;
    }

    public int getNumTracks() {
        return this.trackDelegates.length;
    }

    Choice setupTuningChoice() {
        Choice choices = new Choice();
        choices.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Choice ch = (Choice)e.getSource();
                int index = ch.getSelectedIndex();
                SongDelegate.this.songModel.setTuningSelection(index);
            }
        });
        String[] names = this.songModel.getTuningNames();
        int i = 0;
        while (i < names.length) {
            choices.addItem(names[i]);
            ++i;
        }
        return choices;
    }

    Choice setupKeyChoice() {
        Choice choices = new Choice();
        choices.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Choice ch = (Choice)e.getSource();
                int index = ch.getSelectedIndex();
                int pitch = 36 + index;
                SongDelegate.this.songModel.setFundamental(pitch);
            }
        });
        int i = 0;
        while (i < this.noteNames.length) {
            choices.addItem(this.noteNames[i]);
            ++i;
        }
        return choices;
    }

    Panel setupVolumeBoxes() {
        Panel volumePanel = new Panel();
        CheckboxGroup cbg = new CheckboxGroup();
        ItemListener volListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VolumeRadioBox vrBox = (VolumeRadioBox)e.getSource();
                SongDelegate.this.currentVolumeToSet = vrBox.getIndex();
            }
        };
        String[] texts = new String[]{"quiet", "normal", "loud"};
        int i = 1;
        while (i < TrackDelegate.enabledVolumeColors.length) {
            VolumeRadioBox volBox = new VolumeRadioBox(i, texts[i - 1], cbg, this.currentVolumeToSet == i);
            volBox.addItemListener(volListener);
            volumePanel.add(volBox);
            ++i;
        }
        return volumePanel;
    }

    int getCurrentVolumeToSet() {
        return this.currentVolumeToSet;
    }

    @Override
    public void update(Observable o, Object arg) {
        double bpm = this.songModel.getBeatsPerMinute();
        this.bpmText.setText("" + bpm);
        if (this.tuningChoice != null) {
            this.tuningChoice.select(this.songModel.getTuningSelection());
        }
        if (this.keyChoice != null) {
            int pitch = this.songModel.getFundamental();
            int index = pitch - 60 + 24;
            this.keyChoice.select(index);
        }
        this.repaint();
    }

    public void updateInTimeOf(TrackDelegate trackDelegate) {
        TrackModel longestTrack = this.songModel.findLongestTrack();
        int maxTime = longestTrack.getInTimeOf();
        if (maxTime != this.previousMaxTime) {
            int i = 0;
            while (i < this.trackDelegates.length) {
                if (this.trackDelegates[i] != null) {
                    this.trackDelegates[i].setMaxTimeOf(maxTime);
                }
                ++i;
            }
        }
    }

    @Override
    public void setEnabled(boolean flag) {
        this.bpmText.setEnabled(flag);
        this.tuningChoice.setEnabled(flag);
        this.keyChoice.setEnabled(flag);
    }

    void setTrackSolo(TrackPlayer trackPlayer, boolean isSolo) {
        this.songPlayer.setTrackSolo(trackPlayer, isSolo);
    }

    class VolumeRadioBox
    extends Checkbox {
        int index;

        public VolumeRadioBox(int index, String text, CheckboxGroup cbg, boolean flag) {
            super(text, cbg, flag);
            this.index = index;
            this.setBackground(TrackDelegate.enabledVolumeColors[index]);
        }

        public int getIndex() {
            return this.index;
        }
    }
}

