/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.client;

import com.transjam.client.Client;
import com.transjam.client.ClientAdapter;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;

public abstract class ModelProxy
extends Observable
implements Observer {
    private Client client;
    private ClientAdapter clientAdapter;
    private Observable model;
    private String thingName;
    private String ownerName;
    private int ownerID;

    public ModelProxy(Client pClient, Observable pModel, String pThingName) throws IOException {
        this.client = pClient;
        this.model = pModel;
        this.thingName = pThingName;
        this.clientAdapter = new ClientAdapter(){

            @Override
            public void modifiedThing(String name, String content) throws IOException {
                if (name.equals(ModelProxy.this.thingName) && !ModelProxy.this.isOwned()) {
                    ModelProxy.this.decodeModelData(content);
                }
            }

            @Override
            public void grantedLock(String name, int uid) throws IOException {
                if (name.equals(ModelProxy.this.thingName)) {
                    ModelProxy.this.ownerName = ModelProxy.this.client.getUserName(uid);
                    ModelProxy.this.ownerID = uid;
                    ModelProxy.this.changed();
                }
            }

            @Override
            public void deniedLock(String name, int uid) throws IOException {
                if (name.equals(ModelProxy.this.thingName)) {
                    ModelProxy.this.serverDeniedLock(uid);
                }
            }

            @Override
            public void unlockedThing(String name) throws IOException {
                if (name.equals(ModelProxy.this.thingName)) {
                    ModelProxy.this.nobodyOwns();
                }
            }

            @Override
            public void askedForLock(String name) throws IOException {
                if (name.equals(ModelProxy.this.thingName)) {
                    ModelProxy.this.serverAskedForLock();
                }
            }
        };
    }

    public void serverDeniedLock(int uid) throws IOException {
    }

    public void serverAskedForLock() throws IOException {
        this.client.grantLock(this.thingName);
        this.nobodyOwns();
    }

    public abstract String encodeModelData() throws IOException;

    public abstract void decodeModelData(String var1) throws IOException;

    private void nobodyOwns() {
        this.ownerName = null;
        this.ownerID = 0;
        this.changed();
    }

    public void start() throws IOException {
        this.model.addObserver(this);
        this.client.addMessageListener(this.clientAdapter);
        this.nobodyOwns();
        this.client.lockNewThing(this.thingName, this.encodeModelData());
    }

    public void stop() throws IOException {
        this.unlock();
        this.client.removeMessageListener(this.clientAdapter);
        this.model.deleteObserver(this);
    }

    public void requestLock() {
        try {
            this.client.lockThing(this.thingName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void unlock() {
        try {
            this.client.unlockThing(this.thingName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.isOwned()) {
            this.modifyThing();
        }
    }

    public String getOwnerName() {
        return this.ownerName == null ? "nobody" : this.ownerName;
    }

    public int getOwnerID() {
        return this.ownerID;
    }

    public boolean isOwned() {
        return this.ownerID == this.client.getUserID();
    }

    public Observable getModel() {
        return this.model;
    }

    public String getThingName() {
        return this.thingName;
    }

    public Client getClient() {
        return this.client;
    }

    public void modifyThing() {
        try {
            this.client.modifyThing(this.thingName, this.encodeModelData());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void changed() {
        if (!this.hasChanged()) {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

