/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import com.transjam.awt.ImageCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class WorldMapCanvas
extends ImageCanvas {
    private double scaler;
    private Hashtable users = new Hashtable();
    private double upperLatitude = 80.0;
    private double lowerLatitude = -80.0;

    public WorldMapCanvas() {
        this.recalculate();
    }

    private void recalculate() {
        this.scaler = 1.0 / (this.upperLatitude - this.lowerLatitude);
        this.repaint();
    }

    public int latitudeToY(double latitude) {
        int h = this.bounds().height;
        int y = (int)((double)h * (this.upperLatitude - latitude) * this.scaler);
        return y;
    }

    public int longitudeToX(double longitude) {
        int w = this.bounds().width;
        int x = (int)((double)w * (longitude + 180.0) / 360.0);
        return x;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.green);
        int ye = this.latitudeToY(0.0);
        g.drawLine(0, ye, this.bounds().width, ye);
        Enumeration enumer = this.users.elements();
        while (enumer.hasMoreElements()) {
            WorldMapEntry user = (WorldMapEntry)enumer.nextElement();
            int x = this.longitudeToX(user.longitude);
            int y = this.latitudeToY(user.latitude);
            g.setColor(user.color);
            g.fillOval(x - 5, y - 5, 10, 10);
        }
    }

    protected void clearUsers() {
        this.users.clear();
        this.repaint();
    }

    protected void addUser(int uid, Color color, double latitude, double longitude) {
        WorldMapEntry mapEntry = new WorldMapEntry(uid, color, latitude, longitude);
        this.users.put(new Integer(uid), mapEntry);
        this.repaint();
    }

    protected void removeUser(int uid) {
        this.users.remove(new Integer(uid));
        this.repaint();
    }

    public double getLowerLatitude() {
        return this.lowerLatitude;
    }

    public double getUpperLatitude() {
        return this.upperLatitude;
    }

    public void setLowerLatitude(double d) {
        this.lowerLatitude = d;
        this.recalculate();
    }

    public void setUpperLatitude(double d) {
        this.upperLatitude = d;
        this.recalculate();
    }

    public static void main(String[] args) {
        WorldMapCanvas map = new WorldMapCanvas();
        Frame frame = new Frame("User Location");
        frame.setLayout(new BorderLayout());
        URL url = null;
        try {
            url = new URL("http://www.transjam.com/images/world_72_55.jpg");
            frame.add("Center", map);
            try {
                map.load(url);
                frame.pack();
                map.setUpperLatitude(72.0);
                map.setLowerLatitude(-55.0);
                int i = 0;
                map.addUser(i++, Color.red, 0.0, 0.0);
                map.addUser(i++, Color.green, 49.7, 8.2);
                map.addUser(i++, Color.gray, 47.6, -122.3);
                map.addUser(i++, Color.blue, -36.0, 174.0);
                map.addUser(i++, Color.orange, -34.0, 151.0);
                map.addUser(i++, Color.yellow, 59.9, 10.6);
                map.addUser(i++, Color.white, -6.0, 106.6);
                map.addUser(i++, Color.black, 48.8, 2.033333333333333);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            frame.show();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    class WorldMapEntry {
        int uid;
        double latitude;
        double longitude;
        Color color;

        public WorldMapEntry(int uid, Color color, double latitude, double longitude) {
            this.uid = uid;
            this.latitude = latitude;
            this.longitude = longitude;
            this.color = color;
        }
    }
}

