/*
 * Decompiled with CFR 0.152.
 */
package com.transjam.awt;

import com.transjam.client.ModelProxy;
import java.awt.Button;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;

public class ModelProxyDelegate
extends Panel {
    private ModelProxy modelProxy;
    private Panel coDelegate;
    private Label ownerLabel;
    private Button ownButton;
    private int maxNameCharacters = 8;

    public ModelProxyDelegate(Panel pCoDelegate, ModelProxy pModelProxy) {
        this.coDelegate = pCoDelegate;
        this.modelProxy = pModelProxy;
        this.ownerLabel = new Label(this.getDisplayName());
        this.add(this.ownerLabel);
        this.ownerLabel.setFont(new Font("Monospaced", 0, 12));
        this.ownButton = new Button("Own");
        this.add(this.ownButton);
        this.ownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelProxyDelegate.this.modelProxy.requestLock();
            }
        });
        this.modelProxy.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ModelProxyDelegate.this.ownerLabel.setText(ModelProxyDelegate.this.getDisplayName());
                ModelProxyDelegate.this.ownerLabel.invalidate();
                ModelProxyDelegate.this.ownButton.setEnabled(!ModelProxyDelegate.this.modelProxy.isOwned());
                ModelProxyDelegate.this.coDelegate.setEnabled(ModelProxyDelegate.this.modelProxy.isOwned());
                ModelProxyDelegate.this.coDelegate.repaint();
            }
        });
        this.invalidate();
    }

    private String getDisplayName() {
        String name = this.modelProxy.getOwnerName();
        if (name == null) {
            name = "";
            int i = 0;
            while (i < this.maxNameCharacters) {
                name = String.valueOf(name) + "-";
                ++i;
            }
        } else if (name.length() > this.maxNameCharacters) {
            name = name.substring(0, this.maxNameCharacters);
        }
        return name;
    }
}

