/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.gui.patch.GenericModuleView;
import com.syntona.gui.patch.ModuleView;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.GenericModulePresenter;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.SyntonaModule;

public class ModuleInfo {
    private String type;
    private String group;
    private String legalName;
    private Class<?> moduleClass;
    private Class<?> viewClass;
    private Bundle bundle;

    public ModuleInfo(String group, String type, Class<?> moduleClass, Class<?> viewClass, String legalName) {
        this.group = group;
        this.type = type;
        this.moduleClass = moduleClass;
        this.viewClass = viewClass;
        this.legalName = legalName;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.type;
    }

    public ModulePresenter makeModulePresenter() throws InstantiationException, IllegalAccessException {
        ModulePresenter presenter = null;
        if (this.moduleClass != null) {
            Object obj = this.moduleClass.newInstance();
            presenter = obj instanceof SyntonaModule ? new GenericModulePresenter((SyntonaModule)obj) : (ModulePresenter)obj;
            if (this.viewClass != null) {
                ModuleView view = (ModuleView)this.viewClass.newInstance();
                presenter.setView(view);
            } else if (presenter.getView() == null) {
                presenter.setView(new GenericModuleView(presenter));
            }
        } else {
            presenter = new ModulePresenter();
        }
        presenter.setType(this.type);
        return presenter;
    }

    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

