/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.jsyn.swing.DoubleBoundedRangeModel;
import com.syntona.plugin.InputDoubleJack;
import javax.swing.event.ChangeListener;

public class JackBoundedRangeModel
extends DoubleBoundedRangeModel {
    protected InputDoubleJack inputDoubleJack;

    public JackBoundedRangeModel(InputDoubleJack jack) {
        super(jack.getName(), 1000, jack.getMin(), jack.getMax(), jack.getValue());
        this.inputDoubleJack = jack;
        this.setDoubleValue(jack.getValue());
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.inputDoubleJack.addChangeListener(listener);
    }

    @Override
    public int getValue() {
        return this.doubleToSlider(this.inputDoubleJack.getValue());
    }

    @Override
    public boolean getValueIsAdjusting() {
        return false;
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.inputDoubleJack.removeChangeListener(listener);
    }

    @Override
    public double getDoubleMinimum() {
        if (this.inputDoubleJack == null) {
            return super.getDoubleMinimum();
        }
        return this.inputDoubleJack.getMin();
    }

    @Override
    public double getDoubleMaximum() {
        if (this.inputDoubleJack == null) {
            return super.getDoubleMaximum();
        }
        return this.inputDoubleJack.getMax();
    }

    @Override
    public void setValue(int value) {
        if (value < this.getMinimum()) {
            value = this.getMinimum();
        } else if (value > this.getMaximum()) {
            value = this.getMaximum();
        }
        if (this.inputDoubleJack != null) {
            double dval = this.sliderToDouble(value);
            this.inputDoubleJack.setValue(dval);
        }
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
    }
}

