/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class TestMouseEnteredSwing
extends JApplet
implements MouseListener {
    private static final long serialVersionUID = 1L;
    final JApplet applet = this;
    JTextArea textArea;

    @Override
    public void start() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.white);
        JPanel topPanel = new JPanel();
        topPanel.setPreferredSize(new Dimension(100, 100));
        topPanel.setLayout(new GridLayout(1, 2));
        topPanel.add(new ColoredCanvas(Color.blue));
        topPanel.add(new ColoredCanvas(Color.green));
        this.getContentPane().add("North", topPanel);
        this.textArea = new JTextArea();
        this.getContentPane().add("Center", this.textArea);
        this.println("java.version = " + System.getProperty("java.version"));
        this.validate();
        this.repaint();
    }

    @Override
    public void stop() {
        this.removeAll();
    }

    private void println(String text) {
        this.textArea.append(String.valueOf(text) + "\n");
    }

    private void logMouseEvent(MouseEvent evt) {
        this.println("Got: " + evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.logMouseEvent(evt);
    }

    public static void main(String[] args) {
        TestMouseEnteredSwing test = new TestMouseEnteredSwing();
        JFrame frame = new JFrame("Test Mouse Entered Bug");
        frame.setSize(600, 400);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", test);
        frame.setVisible(true);
        test.start();
    }

    class ColoredCanvas
    extends JComponent {
        private static final long serialVersionUID = 1L;

        ColoredCanvas(Color color) {
            this.setBackground(color);
            this.addMouseListener((MouseListener)((Object)TestMouseEnteredSwing.this.applet));
        }

        @Override
        public void paint(Graphics g) {
            int width = this.getBounds().width;
            int height = this.getBounds().height;
            g.setColor(this.getBackground());
            g.fillRect(1, 1, width - 2, height - 2);
        }
    }
}

