/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.TextOutput;
import com.softsynth.wire.Wire;
import java.awt.Rectangle;
import java.io.File;
import java.util.Hashtable;

abstract class RecursiveLoader {
    String myTag;
    RecursiveLoader subLoader;

    public RecursiveLoader() {
        this("unknown");
    }

    public RecursiveLoader(String tag) {
        this.myTag = tag;
    }

    void handleAttributes(Hashtable attributes) {
    }

    public void beginElement(String tag, Hashtable attributes, boolean ifEmpty) {
        if (this.subLoader != null) {
            this.subLoader.beginElement(tag, attributes, ifEmpty);
        } else {
            this.handleBeginElement(tag, attributes);
        }
        if (ifEmpty) {
            this.nestedEndElement(tag);
        }
    }

    public void handleBeginElement(String tag, Hashtable attributes) {
        TextOutput.println("RecursiveLoader did not recognize tag = " + tag);
    }

    public void foundContent(String content) {
        if (this.subLoader != null) {
            this.subLoader.foundContent(content);
        } else {
            this.handleFoundContent(content);
        }
    }

    public void handleFoundContent(String content) {
    }

    public void endElement(String tag) {
        this.nestedEndElement(tag);
    }

    int nestedEndElement(String tag) {
        if (this.subLoader != null) {
            if (this.subLoader.nestedEndElement(tag) > 0) {
                this.subLoader = null;
            }
        } else if (this.myTag.equals(tag)) {
            this.handleEndElement();
            return 1;
        }
        return 0;
    }

    public void handleEndElement() {
    }

    public int getAttribute(Hashtable attributes, String key, int defaultValue) {
        String s = (String)attributes.get(key);
        return s == null ? defaultValue : Integer.parseInt(s);
    }

    public double getAttribute(Hashtable attributes, String key, double defaultValue) {
        String s = (String)attributes.get(key);
        return s == null ? defaultValue : Double.valueOf(s);
    }

    File resolveRelativePath(File referenceFile, String fileName) {
        File file;
        if (referenceFile != null) {
            File dir = referenceFile.getParentFile();
            while (dir != null) {
                File file2 = new File(dir, fileName);
                if (file2.exists()) {
                    return file2;
                }
                dir = dir.getParentFile();
            }
        }
        if ((file = new File(fileName)).exists()) {
            return file;
        }
        throw new RuntimeException("Could not resolve file " + fileName + " from " + referenceFile);
    }

    File getResolvedFileAttribute(Hashtable attributes, File referenceFile, String key) {
        String fileName = (String)attributes.get(key);
        Wire.convertFileSeparatorsToHost(fileName);
        return this.resolveRelativePath(referenceFile, fileName);
    }

    Rectangle handleEditorAttributes(Hashtable attributes) {
        Rectangle rect = null;
        int x = this.getAttribute(attributes, "xpos", -1);
        int y = this.getAttribute(attributes, "ypos", -1);
        int w = this.getAttribute(attributes, "width", -1);
        int h = this.getAttribute(attributes, "height", -1);
        if (x >= 0 && y >= 0 && w >= 0 && h >= 0) {
            rect = new Rectangle(x, y, w, h);
        }
        return rect;
    }
}

