/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthScalarPort;
import com.softsynth.util.IndentingWriter;
import com.softsynth.util.TextOutput;
import com.softsynth.wire.Module;
import com.softsynth.wire.SynthWireJack;
import com.softsynth.wire.Wire;
import com.softsynth.wire.WireJack;
import java.io.IOException;

class OutputSynthWireJack
extends SynthWireJack {
    public OutputSynthWireJack(Module module, String name, SynthPort port) {
        super(module, name, port);
    }

    @Override
    void setup() {
        this.comp.setBackground(Wire.CONNECT_PORT_COLOR);
        this.setMaxConnected(Integer.MAX_VALUE);
        this.orSupportMask(2);
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public void halfDisconnect(WireJack other) {
        super.halfDisconnect(other);
        try {
            SynthPort otherPort;
            if (this.getSynthPort() instanceof SynthDistributor && (otherPort = ((SynthWireJack)other).getSynthPort()) instanceof SynthInput) {
                ((SynthDistributor)this.port).disconnect((SynthInput)otherPort, other.getPartIndex());
            }
        }
        catch (SynthException e) {
            TextOutput.println("Connect error: " + e);
        }
    }

    @Override
    public double get() {
        return this.port == null ? super.get() : ((SynthScalarPort)this.port).get();
    }

    @Override
    void generateSource(IndentingWriter writer, int phase) throws IOException {
        if (phase == 2) {
            this.generateConnectionSource(writer);
        }
    }
}

