/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.wire.CircuitLoader;
import com.softsynth.wire.ConnectionLoader;
import com.softsynth.wire.EnvelopeLoader;
import com.softsynth.wire.LoaderContext;
import com.softsynth.wire.MiscLoader;
import com.softsynth.wire.PatchLoader;
import com.softsynth.wire.RecursiveLoader;
import com.softsynth.wire.SampleLoader;
import com.softsynth.wire.UnitLoader;
import java.util.Hashtable;

class ModuleGroupLoader
extends RecursiveLoader {
    LoaderContext ldcon;

    public ModuleGroupLoader(String tag, LoaderContext ldcon) {
        super(tag);
        this.ldcon = ldcon;
    }

    @Override
    public void handleBeginElement(String tag, Hashtable attributes) {
        if (tag.equals("patch")) {
            PatchLoader loader = new PatchLoader(tag, this.ldcon);
            this.subLoader = loader;
            this.subLoader.handleAttributes(attributes);
            loader.setupModule(this.ldcon.patch);
        } else if (tag.equals("unit")) {
            UnitLoader loader = new UnitLoader(tag, this.ldcon);
            this.subLoader = loader;
            this.subLoader.handleAttributes(attributes);
            loader.setupModule(this.ldcon.patch);
        } else if (tag.equals("circuit")) {
            CircuitLoader loader = new CircuitLoader(tag, this.ldcon);
            this.subLoader = loader;
            this.subLoader.handleAttributes(attributes);
            loader.setupModule(this.ldcon.patch);
        } else if (tag.equals("misc")) {
            MiscLoader loader = new MiscLoader(tag, this.ldcon);
            this.subLoader = loader;
            this.subLoader.handleAttributes(attributes);
            loader.setupModule(this.ldcon.patch);
        } else if (tag.equals("sample")) {
            this.subLoader = new SampleLoader(tag, this.ldcon);
            this.subLoader.handleAttributes(attributes);
        } else if (tag.equals("envelope")) {
            this.subLoader = new EnvelopeLoader(tag, this.ldcon);
            this.subLoader.handleAttributes(attributes);
        } else if (tag.equals("connection")) {
            this.subLoader = new ConnectionLoader(tag, this.ldcon);
            this.subLoader.handleAttributes(attributes);
        } else {
            super.handleBeginElement(tag, attributes);
        }
    }
}

