/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.util.IndentingWriter;
import com.softsynth.wire.DraggableCanvas;
import com.softsynth.wire.LabelledCanvas;
import com.softsynth.wire.Patch;
import com.softsynth.wire.SaveAsStream;
import com.softsynth.wire.WireJack;
import com.softsynth.wire.WireNameEditor;
import com.softsynth.wire.WirePortNotFoundException;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

abstract class Module {
    JPanel panel;
    Patch patch;
    WireJack kicker;
    LabelledCanvas dragger;
    Vector jacks = new Vector();
    String name;
    String type;
    String comment;
    boolean selected;
    boolean modified = false;
    Rectangle editorBounds;

    public void start() {
    }

    public void stop() {
    }

    boolean edit() {
        WireNameEditor editor = new WireNameEditor(this.patch.getPatchPanel().getFrame(), this, null);
        if (this.editorBounds != null) {
            editor.setBounds(this.editorBounds);
        }
        boolean result = editor.ask() == 1;
        this.editorBounds = editor.getBounds();
        return result;
    }

    boolean editAfterMake() {
        return true;
    }

    public Rectangle getEditorBounds() {
        return this.editorBounds;
    }

    public void setEditorBounds(Rectangle rect) {
        this.editorBounds = rect;
    }

    public void setup(Patch patch, String name, String type) {
        this.setPatch(patch);
        this.setName(name);
        this.setType(type);
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(0, 1));
        this.addDragger();
        this.setupJacks();
        this.calculateSize();
    }

    void setPatch(Patch patch) {
        this.patch = patch;
    }

    Patch getPatch() {
        return this.patch;
    }

    boolean delete() {
        this.disconnectAll();
        if (this.patch != null) {
            this.patch.removeModule(this);
        }
        return false;
    }

    void halfConnect(WireJack myJack, WireJack otherJack) {
        if (myJack.isOutput()) {
            this.sendValue();
        }
    }

    void halfDisconnect(WireJack myJack, WireJack otherJack) {
    }

    public void disconnectAll() {
        int i = 0;
        while (i < this.jacks.size()) {
            WireJack wjack = (WireJack)this.jacks.elementAt(i);
            wjack.disconnectAll();
            ++i;
        }
    }

    public void noteOn(int time, double frequency, double amplitude) {
    }

    public void noteOff(int time) {
    }

    public void setupJacks() {
    }

    public void setModified(boolean flag) {
        this.modified = flag;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void calculateSize() {
        this.panel.setSize(70, 18 * this.panel.getComponentCount());
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setComment(String text) {
        this.comment = text;
    }

    void setLocation(int x, int y) {
        this.panel.setLocation(x, y);
    }

    public void setName(String name) {
        if (this.dragger != null) {
            this.dragger.setText(name);
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.dragger.setHighlighted(selected);
        this.panel.validate();
        this.patch.bringModuleToFront(this);
    }

    public boolean getSelected() {
        return this.selected;
    }

    JPanel getPanel() {
        return this.panel;
    }

    WireJack getJack(String name, int partIndex) {
        WireJack foundJack = null;
        Enumeration enumer = this.jacks.elements();
        while (enumer.hasMoreElements()) {
            WireJack wjack = (WireJack)enumer.nextElement();
            if (!name.equals(wjack.getName()) || wjack.getPartIndex() != partIndex) continue;
            foundJack = wjack;
            break;
        }
        if (foundJack == null) {
            throw new WirePortNotFoundException("Module " + this.getName() + ".getJack() can't find " + name + ", #" + partIndex);
        }
        return foundJack;
    }

    public void addJack(WireJack wjack) {
        this.jacks.addElement(wjack);
    }

    public void addJackCanvas(WireJack wjack) {
        this.addJack(wjack);
        if (this.panel != null) {
            LabelledCanvas lcan = (LabelledCanvas)wjack.getComponent();
            lcan.setSize(70, 18);
            lcan.addMouseListener(this.patch.getPatchPanel());
            lcan.addMouseMotionListener(this.patch.getPatchPanel());
            this.panel.add(lcan);
            this.calculateSize();
            this.panel.validate();
        }
    }

    public void removeJack(WireJack wjack) {
        wjack.disconnectAll();
        this.jacks.removeElement(wjack);
        if (this.panel != null) {
            this.panel.remove(wjack.getComponent());
            this.calculateSize();
            this.panel.validate();
            this.panel.getParent().repaint();
        }
    }

    public void removeJack(String portName, int partIndex) {
        WireJack wjack = this.getJack(portName, partIndex);
        if (wjack != null) {
            this.removeJack(wjack);
        }
    }

    public void removeFromPatch() {
    }

    void addDragger() {
        this.dragger = new DraggableCanvas(this.name);
        this.panel.add(this.dragger);
        this.dragger.setWireJack(new WireJack(this, this.dragger, this.getName()));
        this.dragger.getWireJack().setDragged(this);
        this.dragger.addMouseListener(this.patch.getPatchPanel());
        this.dragger.addMouseMotionListener(this.patch.getPatchPanel());
    }

    abstract String getTagName();

    void sendValue() {
    }

    public void drawConnections(Graphics g, Point refLoc) {
        int i = 0;
        while (i < this.jacks.size()) {
            WireJack wjack = (WireJack)this.jacks.elementAt(i);
            wjack.drawConnections(g, refLoc, this.getSelected());
            ++i;
        }
    }

    public void generateSource(IndentingWriter writer, int phase) throws IOException {
        int i = 0;
        while (i < this.jacks.size()) {
            WireJack wjack = (WireJack)this.jacks.elementAt(i);
            wjack.generateSource(writer, phase);
            ++i;
        }
    }

    public boolean saveTreeIfNeeded() {
        return false;
    }

    void saveConnectionsToStream(Vector units, SaveAsStream stream) throws IOException {
        int i = 0;
        while (i < this.jacks.size()) {
            WireJack wjack = (WireJack)this.jacks.elementAt(i);
            wjack.saveConnectionsToStream(units, stream);
            ++i;
        }
        if (stream.getTargetFile() != null) {
            this.setModified(false);
        }
    }

    public void saveModuleParamToStream(SaveAsStream stream) {
    }

    void saveContentToStream(SaveAsStream stream) throws IOException {
    }

    void saveJacksToStream(SaveAsStream stream) throws IOException {
        int i = 0;
        while (i < this.jacks.size()) {
            WireJack wjack = (WireJack)this.jacks.elementAt(i);
            wjack.saveToStream(stream);
            ++i;
        }
    }

    public void saveCreationToStream(SaveAsStream stream) throws IOException {
        stream.beginModule(this.getTagName(), this.getName(), this.getType(), this.panel.getLocation());
        this.saveModuleParamToStream(stream);
        stream.println(">");
        this.saveContentToStream(stream);
        this.saveJacksToStream(stream);
        stream.endModule(this.getTagName());
    }

    boolean loadFromFile(File file) {
        return false;
    }

    public void kick(double time) {
    }
}

