/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.wire;

import com.softsynth.wire.Patchable;
import com.softsynth.wire.WireJack;
import java.awt.Graphics;
import javax.swing.JComponent;

class LabelledCanvas
extends JComponent
implements Patchable {
    private static final long serialVersionUID = 1L;
    boolean highlighted = false;
    String text;
    WireJack patcher;

    public LabelledCanvas(String text) {
        this.setText(text);
    }

    public LabelledCanvas() {
        this(null);
    }

    void setText(String text) {
        this.text = text;
        this.repaint();
    }

    String getText() {
        return this.text;
    }

    public void setHighlighted(boolean flag) {
        this.highlighted = flag;
        this.repaint();
    }

    public boolean getHighlighted() {
        return this.highlighted || this.patcher != null && this.patcher.getHighlighted();
    }

    @Override
    public WireJack getWireJack() {
        return this.patcher;
    }

    @Override
    public void setWireJack(WireJack patcher) {
        this.patcher = patcher;
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        g.setColor(this.getHighlighted() ? this.getForeground() : this.getBackground());
        g.fillRect(1, 1, width - 2, height - 2);
        if (this.text != null) {
            g.setColor(this.getHighlighted() ? this.getBackground() : this.getForeground());
            g.drawString(this.text, 3, height - 4);
        }
        g.setColor(this.getForeground());
        g.drawRect(1, 1, width - 2, height - 2);
        if (this.patcher != null && this.patcher.isOutput()) {
            int len = height >> 1;
            g.fillRect(width - len, height >> 2, len, len);
        }
    }
}

