/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.support;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.support.Diagnosable;
import java.awt.TextArea;

public class JSynDiagnostic
implements Diagnosable {
    TextArea textArea;
    static final int FLAG_NON_REAL_TIME = 4;

    void write(String msg) {
        if (this.textArea != null) {
            this.textArea.append(msg);
        } else {
            System.out.print(msg);
        }
    }

    @Override
    public boolean test(int index, TextArea textArea) {
        this.textArea = textArea;
        try {
            SynthContext syncon = new SynthContext();
            syncon.delete();
            int version = Synth.getVersion();
            this.write("SUCCESS #" + index++ + " - Loaded DLL version " + version + ".\n");
        }
        catch (Error e) {
            this.write("ERROR #" + index++ + " - Could not load JSyn DLL or Library!\n");
            this.write("Caught: " + e);
            return true;
        }
        try {
            if (Synth.openCount > 0) {
                this.write("Note: openCount = " + Synth.openCount + ", indicates Synth already open!\n");
            }
            Synth.startEngine(4);
            this.write("SUCCESS #" + index++ + " - Started JSyn in NON-real-time!\n");
            Synth.stopEngine();
        }
        catch (Error e) {
            this.write("ERROR #" + index++ + " - Could not start JSyn in NON-real-time!\n");
            this.write("Caught: " + e);
            return true;
        }
        if (this.testStartStop(index++, "ERROR", "for output", 0)) {
            return true;
        }
        if (this.testStartStop(index++, "WARNING", "for input", 96)) {
            return true;
        }
        return this.testStartStop(index++, "WARNING", "for simultaneous input AND output", 32);
    }

    boolean testStartStop(int index, String severity, String message, int flags) {
        boolean ifBad;
        block8: {
            ifBad = false;
            try {
                try {
                    Synth.startEngine(flags);
                    this.write("SUCCESS #" + index++ + " - Started JSyn " + message + " in real-time-mode.\n");
                }
                catch (SynthException e1) {
                    if (Synth.openCount > 0) {
                        try {
                            double rate = 22050.0;
                            Synth.startEngine(flags, rate);
                            this.write("SUCCESS #" + index++ + " - Started JSyn " + message + " at " + (int)rate + " Hz.\n");
                        }
                        catch (SynthException e2) {
                            this.write(String.valueOf(severity) + " #" + index++ + " - Could not start JSyn  " + message + " at either frame rate!\n");
                            ifBad = true;
                        }
                        break block8;
                    }
                    this.write(String.valueOf(severity) + " #" + index++ + " - Could not start JSyn " + message + "!\n");
                    ifBad = true;
                }
            }
            catch (Error e) {
                this.write(String.valueOf(severity) + " #" + index++ + " - Could not start JSyn " + message + "!\n");
                this.write("Caught: " + e);
                ifBad = true;
            }
        }
        if (!ifBad) {
            Synth.stopEngine();
        }
        return ifBad;
    }
}

