/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.support;

import com.softsynth.support.Diagnosable;
import java.applet.Applet;
import java.awt.Frame;
import java.awt.TextArea;

public class DiagnoseJSyn
extends Applet {
    TextArea textArea;

    public static void main(String[] args) {
        DiagnoseJSyn applet = new DiagnoseJSyn();
        Frame f = new Frame("Applet Frame");
        f.add("Center", applet);
        applet.init();
        applet.start();
        f.setSize(600, 350);
        f.show();
    }

    @Override
    public void start() {
        this.textArea = new TextArea(15, 72);
        this.add(this.textArea);
        System.out.println("Starting DiagnoseJSyn Applet");
        this.getParent().validate();
        this.getToolkit().sync();
        this.showProp("java.version");
        this.showProp("java.vendor");
        this.showProp("os.name");
        this.showProp("os.arch");
        this.showProp("os.version");
        this.test();
    }

    void showProp(String key) {
        try {
            String value = System.getProperty(key);
            if (value == null) {
                value = "UNDEFINED";
            }
            this.write(String.valueOf(key) + " = " + value + "\n");
        }
        catch (SecurityException e) {
            this.write(e + " accessing " + key + "\n");
        }
    }

    boolean test() {
        boolean ifBad = true;
        int index = 1;
        if (this.checkClass(index++, "com.softsynth.jsyn.CuePoint") == null) {
            return true;
        }
        Class diagClass = this.checkClass(index++, "com.softsynth.support.JSynDiagnostic");
        try {
            Diagnosable diag = (Diagnosable)diagClass.newInstance();
            ifBad = diag.test(index, this.textArea);
        }
        catch (Exception e) {
            this.write("Caught: " + e);
        }
        return ifBad;
    }

    Class checkClass(int testNum, String className) {
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
            this.write("SUCCESS #" + testNum + " - Loaded JSyn " + className + " Class.\n");
        }
        catch (ClassNotFoundException e) {
            this.write("ERROR #" + testNum + " - Could not load JSyn " + className + " Class!\n");
            this.write("Caught: " + e);
            cl = null;
        }
        catch (Throwable thr) {
            this.write("ERROR #" + testNum + " - Could not load JSyn " + className + " Class!\n");
            this.write("Caught: " + thr);
            cl = null;
        }
        return cl;
    }

    void write(String msg) {
        if (this.textArea != null) {
            this.textArea.append(msg);
        } else {
            System.out.print(msg);
        }
    }

    @Override
    public void stop() {
        this.removeAll();
    }
}

