/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SynthSampleQueue;
import com.softsynth.jsyn.util.SampleQueueStream;

public class SampleQueueOutputStream
extends SampleQueueStream {
    public SampleQueueOutputStream(SynthSampleQueue queue, int bufferSizeInFrames, int channelsPerFrame) {
        super(queue, bufferSizeInFrames, channelsPerFrame);
    }

    public boolean getUnderflowed() {
        this.available();
        return this.flowError;
    }

    @Override
    int calcAvailable(int frameCount) {
        return this.sample.getNumFrames() - frameCount;
    }

    public int write(short[] data, int offset, int numFrames) {
        return this.move(data, offset, numFrames);
    }

    public int flush() {
        if (!this.running) {
            return this.frameCount;
        }
        int framesLeft = 0;
        while ((framesLeft = this.sample.getNumFrames() - this.available()) > 0) {
            System.out.println("framesLeft = " + framesLeft);
            int ticksToSleep = this.frameCount / (2 * this.sample.getSynthContext().getFramesPerTick());
            this.sample.getSynthContext().sleepForTicks(ticksToSleep + 1);
        }
        return 0;
    }

    @Override
    void moveDirect(int moveIndex, short[] data, int offset, int numFrames) {
        this.sample.write(moveIndex, data, offset, numFrames);
    }
}

