/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.qa;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.qa.QA_Tools;
import java.applet.Applet;
import java.awt.Component;
import java.awt.TextArea;

public class QA_DistributorBug1
extends Applet {
    QA_Tools tools;
    AddUnit adder1;
    AddUnit adder2;
    SynthDistributor distro;

    public static void main(String[] args) {
        QA_DistributorBug1 applet = new QA_DistributorBug1();
        AppletFrame frame = new AppletFrame("Load All Units", applet);
        frame.resize(600, 450);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        TextArea report = new TextArea(25, 70);
        this.add(report);
        this.tools = new QA_Tools(report);
        this.getParent().validate();
        this.getToolkit().sync();
        try {
            Synth.startEngine(0);
            this.adder1 = new AddUnit();
            this.distro = new SynthDistributor("distro");
            this.adder2 = new AddUnit();
            this.tools.println("Distributor " + this.distro + " has " + this.distro.getNumParts() + " parts.");
            this.distro.connect(this.adder2.inputA);
            this.distro.connect(this.adder2.inputB);
            this.adder1.start();
            this.adder2.start();
            this.checkResult(0.1, this.distro);
            this.checkResult(-0.2, this.distro);
            this.adder1.output.connect(this.distro);
            this.checkResult(0.2, this.adder1.inputA);
            this.checkResult(-0.1, this.adder1.inputA);
            this.adder2.inputA.disconnect();
            this.checkResultNot(0.39, this.adder1.inputA);
            this.checkResultNot(12.7, this.adder1.inputA);
            this.distro.connect(this.adder2.inputA);
            this.checkResult(0.7, this.adder1.inputA);
            this.checkResult(-0.04, this.adder1.inputA);
            this.distro.disconnect(this.adder2.inputB);
            this.checkResultNot(0.93, this.adder1.inputA);
            this.checkResultNot(5.7, this.adder1.inputA);
            this.distro.connect(this.adder2.inputB);
            this.checkResult(0.333, this.adder1.inputA);
            this.checkResult(-0.74, this.adder1.inputA);
            this.distro.disconnect();
            this.checkResultNot(0.553, this.adder1.inputA);
            this.checkResultNot(5.3, this.adder1.inputA);
            this.tools.printSummary();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void checkResult(double a, SynthInput port) throws SynthException {
        double c = a * 2.0;
        port.set(a);
        Synth.sleepForTicks(20);
        double answer = this.adder2.output.get();
        if (this.tools.matchDoubles(answer, c, 1.0E-5)) {
            this.tools.printSuccess("set, " + a + " * 2 == " + answer);
        } else {
            this.tools.printError("set, " + a + " * 2 != " + answer);
        }
    }

    void checkResultNot(double a, SynthInput port) throws SynthException {
        double c = a * 2.0;
        port.set(a);
        Synth.sleepForTicks(20);
        double answer = this.adder2.output.get();
        if (!this.tools.matchDoubles(answer, c, 1.0E-5)) {
            this.tools.printSuccess("set, " + a + " * 2 != " + answer);
        } else {
            this.tools.printError("set, " + a + " * 2 == " + answer);
        }
    }

    @Override
    public void stop() {
        try {
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

