/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.tuna;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthBusInput;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.circuits.FilteredSawtoothBL;
import com.softsynth.jsyn.examples.tuna.DynamicPitchGenerator;
import com.softsynth.jsyn.examples.tuna.MelodicSequence;
import com.softsynth.jsyn.examples.tuna.TunaRiff;
import java.awt.Label;
import java.awt.Panel;

class TunaLead
extends TunaRiff {
    DynamicPitchGenerator pitchGen;
    Label label;

    public TunaLead(Panel panel, SynthBusInput bus, double ampl) throws SynthException {
        super(panel, "Lead", bus, new FilteredSawtoothBL(), ampl);
        this.pitchGen = new DynamicPitchGenerator(440.0, 100.0, 1000.0, this.rand);
        this.label = new Label("0");
        this.riffPanel.add(this.label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void change(MelodicSequence melody) {
        MelodicSequence melodicSequence = melody;
        synchronized (melodicSequence) {
            melody.clear();
            int beat = melody.getTicksPerBeat();
            int i = 0;
            while (i < 8) {
                double amp = this.ampl * (1.0 - (double)i / 16.0);
                int dur = (this.rand.nextInt() & 1) == 0 ? beat : beat * 2;
                melody.add(dur, this.pitchGen.nextPitch(1.0), amp);
                ++i;
            }
        }
    }

    @Override
    public boolean play(int time, MelodicSequence melody) throws SynthException {
        boolean ifChange = super.play(time, melody);
        this.change(melody);
        this.label.setText("T=" + Synth.getTickCount() + ", freq = " + melody.pitchAt(0));
        this.label.getParent().validate();
        if (this.playBox.getState()) {
            int i = 0;
            while (i < melody.size()) {
                this.unitNote.note(time, melody.durationAt(i) / 2, melody.pitchAt(i), melody.amplitudeAt(i));
                time += melody.durationAt(i);
                ++i;
            }
        }
        return ifChange;
    }
}

