/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples.pinwheels;

import com.softsynth.jsyn.EqualTemperedTuning;
import com.softsynth.jsyn.examples.pinwheels.ContourSpinner;

class PitchSpinner
extends ContourSpinner {
    static final double PITCH_SCALAR = 12.0 * Math.sqrt(2.0);
    static int[] pitches;
    static final EqualTemperedTuning tuning;

    static {
        int[] nArray = new int[11];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 9;
        nArray[5] = 12;
        nArray[6] = 14;
        nArray[7] = 16;
        nArray[8] = 19;
        nArray[9] = 21;
        nArray[10] = 24;
        pitches = nArray;
        tuning = new EqualTemperedTuning(293.3);
    }

    public PitchSpinner(int numPoints) {
        super(numPoints);
    }

    @Override
    void makeRandomPoints(int numPoints) {
        double range = 1.0 / Math.sqrt(2.0);
        int i = 0;
        while (i < numPoints) {
            this.xData[i] = (double)((int)(16.0 * Math.random())) / 16.0 * 2.0 * range - range;
            this.yData[i] = (double)(pitches[(int)(Math.random() * (double)pitches.length)] - 12) / PITCH_SCALAR;
            ++i;
        }
        this.sortDataByX();
        if (this.xyDisplay != null) {
            this.xyDisplay.repaint();
        }
    }

    double yToFrequency(double yval) {
        return tuning.getFrequency(yval * PITCH_SCALAR + 12.0);
    }
}

