/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.ImpulseOscillator;
import com.softsynth.jsyn.ImpulseOscillatorBL;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.LinearLag;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.PanUnit;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.SawtoothOscillator;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.SawtoothOscillatorDPW;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.SquareOscillator;
import com.softsynth.jsyn.SquareOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOscillator;
import com.softsynth.jsyn.SynthUnit;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view11x.DecibelPortFader;
import com.softsynth.jsyn.view11x.ExponentialPortFader;
import com.softsynth.jsyn.view11x.PortFader;
import com.softsynth.jsyn.view11x.SynthScope;
import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class TJ_SeeOsc
extends Applet {
    LineOut lineOut;
    MultiplyUnit ampUnit;
    PanUnit panUnit;
    LinearLag lagUnit;
    SynthScope scope;
    PortFader freqFader;
    PortFader panFader;
    PortFader ampFader;
    Checkbox[] sourceBoxes;
    Vector sounds;
    Vector names;
    Panel cboxPanel;
    SynthOscillator previous = null;

    public static void main(String[] args) {
        TJ_SeeOsc applet = new TJ_SeeOsc();
        AppletFrame frame = new AppletFrame("See Osc Waveforms", applet);
        frame.setSize(600, 500);
        frame.show();
        frame.test();
    }

    void makeCBoxPanel() {
        this.cboxPanel = new Panel();
        this.cboxPanel.setLayout(new GridLayout(0, 1));
        Panel topRow = new Panel();
        topRow.setLayout(new GridLayout(1, 0));
        this.cboxPanel.add(topRow);
        Panel bottomRow = new Panel();
        bottomRow.setLayout(new GridLayout(1, 0));
        this.cboxPanel.add(bottomRow);
        CheckboxGroup cbg = new CheckboxGroup();
        this.sourceBoxes = new Checkbox[this.sounds.size()];
        int i = 0;
        while (i < this.sourceBoxes.length) {
            this.sourceBoxes[i] = new Checkbox((String)this.names.elementAt(i), cbg, i == 0);
            if ((i & 1) == 0) {
                topRow.add(this.sourceBoxes[i]);
            } else {
                bottomRow.add(this.sourceBoxes[i]);
            }
            this.sourceBoxes[i].addItemListener(new OscItemListener(i));
            ++i;
        }
    }

    void useNthSound(int soundIndex) throws SynthException {
        if (this.previous != null) {
            this.previous.stop();
        }
        SynthOscillator osc = (SynthOscillator)this.sounds.elementAt(soundIndex);
        osc.output.connect(this.ampUnit.inputA);
        osc.start();
        this.previous = osc;
    }

    @Override
    public void start() {
        this.sounds = new Vector();
        this.names = new Vector();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraint = new GridBagConstraints();
        this.setLayout(gridbag);
        constraint.fill = 1;
        constraint.weightx = 1.0;
        constraint.weighty = 1.0;
        try {
            Synth.requestVersion(141);
            Synth.startEngine(0);
            this.sounds.addElement(new SineOscillator());
            this.names.addElement("Sine");
            this.sounds.addElement(new RedNoise());
            this.names.addElement("RedNoise");
            this.sounds.addElement(new SawtoothOscillator());
            this.names.addElement("Saw");
            this.sounds.addElement(new SawtoothOscillatorBL());
            this.names.addElement("SawBL");
            this.sounds.addElement(new SawtoothOscillatorDPW());
            this.names.addElement("SawDPW");
            this.sounds.addElement(new SquareOscillator());
            this.names.addElement("Square");
            this.sounds.addElement(new SquareOscillatorBL());
            this.names.addElement("SquareBL");
            this.sounds.addElement(new ImpulseOscillator());
            this.names.addElement("Impulse");
            this.sounds.addElement(new ImpulseOscillatorBL());
            this.names.addElement("ImpBL");
            this.sounds.addElement(new TriangleOscillator());
            this.names.addElement("Triangle");
            this.ampUnit = new MultiplyUnit();
            this.panUnit = new PanUnit();
            this.lineOut = new LineOut();
            this.lagUnit = new LinearLag();
            this.lagUnit.time.set(0.05);
            this.useNthSound(0);
            int i = 0;
            while (i < this.sounds.size()) {
                SynthOscillator osc = (SynthOscillator)this.sounds.elementAt(i);
                this.lagUnit.output.connect(osc.frequency);
                ++i;
            }
            this.ampUnit.output.connect(this.panUnit.input);
            this.panUnit.output.connect(0, this.lineOut.input, 0);
            this.panUnit.output.connect(1, this.lineOut.input, 1);
            this.scope = new SynthScope();
            this.add(this.scope);
            this.scope.createProbe(this.ampUnit.output, "Output", Color.ORANGE);
            this.scope.finish();
            constraint.gridwidth = 0;
            constraint.gridheight = 1;
            constraint.weighty = 1.0;
            gridbag.setConstraints(this.scope, constraint);
            this.freqFader = new ExponentialPortFader(this.lagUnit.input, "Frequency", 440.0, 50.0, Synth.getFrameRate() / 2.0);
            this.add(this.freqFader);
            constraint.gridheight = 1;
            constraint.weighty = 0.0;
            gridbag.setConstraints(this.freqFader, constraint);
            this.panFader = new PortFader(this.panUnit.pan, "Pan", 0.0, -1.0, 1.0);
            this.add(this.panFader);
            constraint.gridheight = 1;
            constraint.weighty = 0.0;
            gridbag.setConstraints(this.panFader, constraint);
            this.ampFader = new DecibelPortFader(this.ampUnit.inputB, "Level (dB)", -3.0, -60.0, 0.0);
            this.add(this.ampFader);
            constraint.gridheight = -1;
            gridbag.setConstraints(this.ampFader, constraint);
            this.makeCBoxPanel();
            constraint.gridheight = 0;
            gridbag.setConstraints(this.cboxPanel, constraint);
            this.add(this.cboxPanel);
            this.ampUnit.start();
            this.panUnit.start();
            this.lagUnit.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.ampUnit.delete();
            this.lagUnit.delete();
            this.lineOut.delete();
            Enumeration enumer = this.sounds.elements();
            while (enumer.hasMoreElements()) {
                SynthUnit unit = (SynthUnit)enumer.nextElement();
                unit.delete();
            }
            this.sounds.removeAllElements();
            this.removeAll();
            Synth.setTrace(0);
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    class OscItemListener
    implements ItemListener {
        int oscIndex;

        public OscItemListener(int oscIndex) {
            this.oscIndex = oscIndex;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TJ_SeeOsc.this.useNthSound(this.oscIndex);
        }
    }
}

