/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.util.StreamRecorder;
import com.softsynth.jsyn.util.WAVFileWriter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TJ_NonRealTime {
    SineOscillator myOsc;
    static final double FRAME_RATE = 44100.0;
    static final int FRAMES_PER_BUFFER = 8192;
    static final double TOTAL_TIME = 10.0;
    static final int TOTAL_FRAMES = 441000;
    static final int NUM_REC_CHANNELS = 1;
    StreamRecorder recorder;
    WAVFileWriter wavWriter;
    BufferedOutputStream outStream;
    RandomAccessFile rfile;
    long benchStart;
    long benchStop;

    public static void main(String[] args) {
        TJ_NonRealTime app = new TJ_NonRealTime();
        app.test();
        System.exit(0);
    }

    public void test() {
        Synth.requestVersion(141);
        String fileName = "recorded.wav";
        try {
            this.rfile = new RandomAccessFile(fileName, "rw");
            this.wavWriter = new WAVFileWriter(this.rfile);
            this.outStream = new BufferedOutputStream(this.wavWriter);
            System.out.println("Recording to file " + fileName);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (SecurityException e) {
            System.err.println(e);
        }
        try {
            this.wavWriter.writeHeader(1, 44100);
            Synth.startEngine(4, 44100.0);
            this.myOsc = new SineOscillator();
            this.recorder = new StreamRecorder(this.outStream, 8192, 4, 1);
            this.myOsc.output.connect(this.recorder.input);
            int time = Synth.getTickCount() + 20;
            this.benchStart = System.currentTimeMillis();
            this.myOsc.start(time);
            this.recorder.start(time);
            int totalTicks = 441000 / Synth.getFramesPerTick();
            int numNotes = 8;
            int dur = totalTicks / numNotes;
            double freq = 200.0;
            int i = 0;
            while (i < numNotes) {
                this.myOsc.frequency.set(time, freq);
                freq *= 1.3333333333333333;
                Synth.sleepUntilTick(time += dur);
                ++i;
            }
            this.recorder.stop(time);
            this.myOsc.stop(time);
            this.outStream.flush();
            this.wavWriter.fixSizes();
            this.outStream.close();
            this.rfile.close();
            this.benchStop = System.currentTimeMillis();
            double realSeconds = 0.001 * (double)(this.benchStop - this.benchStart);
            System.out.print("Took " + realSeconds + " seconds");
            System.out.println(" to generate and write 10.0 seconds worth of sound.");
            Synth.stopEngine();
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (SynthException e) {
            System.err.println(e);
        }
    }
}

