/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.EnvelopePoints;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view11x.EditListener;
import com.softsynth.jsyn.view11x.EnvelopeEditor;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class TJ_EnvEdit3
extends Applet
implements EditListener {
    LineOut lineOut;
    SineOscillator osc;
    EnvelopeEditor envEditor;
    SynthEnvelope envelope;
    EnvelopePlayer envPlayer;
    EnvelopePoints points;
    final int MAX_FRAMES = 16;
    Button onButton;
    Button offButton;
    Button clearButton;
    boolean looping = false;
    SynthContext synthContext;

    public static void main(String[] args) {
        TJ_EnvEdit3 applet = new TJ_EnvEdit3();
        AppletFrame frame = new AppletFrame("Test EnvelopeEditor", applet);
        frame.resize(600, 400);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        Synth.requestVersion(141);
        this.setLayout(new BorderLayout());
        try {
            this.synthContext = new SynthContext();
            this.synthContext.startEngine(0);
            this.envelope = new SynthEnvelope(this.synthContext, 16);
            this.envPlayer = new EnvelopePlayer(this.synthContext);
            this.osc = new SineOscillator(this.synthContext);
            this.lineOut = new LineOut(this.synthContext);
            this.envPlayer.output.connect(0, this.osc.frequency, 0);
            this.osc.output.connect(0, this.lineOut.input, 0);
            this.osc.output.connect(0, this.lineOut.input, 1);
            this.osc.amplitude.set(0.8);
            this.envEditor = new EnvelopeEditor();
            this.add("Center", this.envEditor);
            this.envEditor.setBackground(Color.cyan.brighter());
            this.envEditor.addEditListener(this);
            this.points = new EnvelopePoints();
            this.points.setName(this.osc.amplitude.getName());
            this.points.add(0.5, 600.0);
            this.points.add(0.5, 200.0);
            this.points.add(0.5, 800.0);
            this.points.add(0.5, 0.0);
            this.updateEnvelope();
            this.envEditor.setPoints(this.points);
            this.envEditor.setMaxPoints(16);
            this.envEditor.setMaxWorldY(1000.0);
            Panel buttonPanel = new Panel();
            this.add((Component)buttonPanel, "South");
            Choice presets = new Choice();
            buttonPanel.add(presets);
            presets.add("Points");
            presets.add("Sustain");
            presets.add("Release");
            presets.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (((String)e.getItem()).equals("Points")) {
                        TJ_EnvEdit3.this.envEditor.setMode(0);
                    } else if (((String)e.getItem()).equals("Sustain")) {
                        TJ_EnvEdit3.this.envEditor.setMode(1);
                    } else if (((String)e.getItem()).equals("Release")) {
                        TJ_EnvEdit3.this.envEditor.setMode(2);
                    }
                }
            });
            this.onButton = new Button("On");
            buttonPanel.add(this.onButton);
            this.onButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_EnvEdit3.this.noteOn();
                }
            });
            this.offButton = new Button("Off");
            buttonPanel.add(this.offButton);
            this.offButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TJ_EnvEdit3.this.noteOff();
                }
            });
            this.envPlayer.start();
            this.lineOut.start();
            this.osc.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        try {
            this.lineOut.delete();
            this.lineOut = null;
            this.osc.delete();
            this.osc = null;
            this.envPlayer.delete();
            this.envPlayer = null;
            this.removeAll();
            this.synthContext.setTrace(0);
            this.synthContext.stopEngine();
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void objectEdited(Object editor, Object objPoints) {
    }

    public void updateEnvelope() {
        int numFrames = this.points.size();
        int i = 0;
        while (i < numFrames) {
            this.envelope.write(i, this.points.getPoint(i), 0, 1);
            ++i;
        }
        this.envelope.setSustainLoop(this.points.getSustainBegin(), this.points.getSustainEnd());
        this.envelope.setReleaseLoop(this.points.getReleaseBegin(), this.points.getReleaseEnd());
    }

    public void noteOn() {
        this.updateEnvelope();
        this.envPlayer.envelopePort.queueOn(this.envelope);
    }

    public void noteOff() {
        this.updateEnvelope();
        this.envPlayer.envelopePort.queueOff(this.envelope);
    }
}

