/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.examples;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;

class NoodlerThread
extends Thread {
    volatile boolean go = true;
    int tickNumber;
    int duration;
    int startTime;
    static int nextID = 0;
    int id = nextID++;
    public SineOscillator myOsc;
    public LineOut myOut;

    public NoodlerThread(int startTime, int duration) throws SynthException {
        this.duration = duration;
        this.startTime = startTime;
        this.myOsc = new SineOscillator();
        this.myOut = new LineOut();
        this.myOsc.amplitude.set(0.2);
        this.myOsc.output.connect(0, this.myOut.input, 0);
        this.myOsc.output.connect(0, this.myOut.input, 1);
    }

    void stopSound() {
        try {
            this.myOut.stop();
            this.myOsc.stop();
        }
        catch (SynthException e) {
            System.err.println(e);
        }
    }

    public void halt() {
        this.go = false;
        this.interrupt();
    }

    @Override
    public void run() {
        try {
            Synth.sleepUntilTick(this.startTime - Synth.timeAdvance);
            this.tickNumber = this.startTime;
            this.myOsc.frequency.set(0.0);
            this.myOut.start(this.tickNumber);
            this.myOsc.start(this.tickNumber);
            int i = 0;
            while (i < 10 && this.go) {
                double frequency = Math.random() * 200.0 + 400.0;
                this.myOsc.frequency.set(this.tickNumber, frequency);
                this.tickNumber += this.duration;
                Synth.sleepUntilTick(this.tickNumber - Synth.timeAdvance);
                ++i;
            }
        }
        catch (SynthException e) {
            System.err.println(e);
        }
        this.stopSound();
    }
}

