/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.ExponentialLag;
import com.softsynth.jsyn.MultiplyUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthDistributor;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.SynthVariable;
import com.softsynth.jsyn.TriangleOscillator;

public class RingModBell
extends SynthNote {
    public TriangleOscillator osc1;
    public TriangleOscillator osc2;
    public ExponentialLag expLag;
    public MultiplyUnit freqScalar;
    public MultiplyUnit ringMod;
    public AddUnit ampMixer;
    public SynthInput modIndex;
    public SynthVariable halfLife;

    public RingModBell() throws SynthException {
        this(Synth.getSharedContext());
    }

    public RingModBell(SynthContext synthContext) throws SynthException {
        this.osc1 = new TriangleOscillator(synthContext);
        this.add(this.osc1);
        this.osc2 = new TriangleOscillator(synthContext);
        this.add(this.osc2);
        this.ampMixer = new AddUnit(synthContext);
        this.add(this.ampMixer);
        this.expLag = new ExponentialLag(synthContext);
        this.add(this.expLag);
        this.freqScalar = new MultiplyUnit(synthContext);
        this.add(this.freqScalar);
        this.ringMod = new MultiplyUnit(synthContext);
        this.add(this.ringMod);
        this.amplitude = this.osc2.amplitude;
        this.addPort(this.amplitude);
        this.modIndex = this.freqScalar.inputB;
        this.addPort(this.modIndex, "modIndex");
        this.halfLife = this.expLag.halfLife;
        this.addPort(this.halfLife);
        this.output = this.ringMod.output;
        this.addPort(this.output);
        this.frequency = new SynthDistributor(this, "frequency");
        this.osc2.output.connect(this.ringMod.inputA);
        this.ampMixer.output.connect(this.ringMod.inputB);
        this.expLag.output.connect(this.ampMixer.inputA);
        this.expLag.output.connect(this.osc1.amplitude);
        this.osc1.output.connect(this.ampMixer.inputB);
        this.frequency.connect(this.osc2.frequency);
        this.frequency.connect(this.freqScalar.inputA);
        this.freqScalar.output.connect(this.osc1.frequency);
        this.frequency.setup(0.0, 5000.0, 10000.0);
        this.modIndex.setup(0.0, 0.8, 10.0);
        this.amplitude.setup(0.0, 0.5, 1.0);
        this.halfLife.setup(0.0, 0.2, 1.0);
    }

    @Override
    public void setStage(int time, int stage) throws SynthException {
        switch (stage) {
            case 0: {
                double half = this.halfLife.get();
                this.expLag.halfLife.set(time, 0.001);
                this.expLag.input.set(time, 0.5);
                this.expLag.halfLife.set(time + 20, half);
                this.expLag.input.set(time + 20, 0.0);
                this.start(time);
                break;
            }
        }
    }
}

