/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthTable;
import com.softsynth.jsyn.WaveShaper;
import junit.framework.TestCase;

public class TestTable
extends TestCase {
    static double[] testInputs = new double[]{0.0, -1.0, 1.0, -5.2, 6.7, -0.3861, 0.5672, 0.001, -0.001};

    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
    }

    @Override
    protected void tearDown() throws Exception {
        Synth.stopEngine();
    }

    public void testLookupShort() {
        short[] data = new short[]{100, 5678, 9186, -17900, -5992, 18723, 987};
        SynthTable table = new SynthTable(data.length);
        TestTable.assertEquals("Table length ", data.length, table.length());
        table.write(data);
        WaveShaper waveShaper = new WaveShaper();
        waveShaper.start();
        waveShaper.tablePort.setTable(table);
        double[] dArray = testInputs;
        int n = testInputs.length;
        int n2 = 0;
        while (n2 < n) {
            double input = dArray[n2];
            this.checkShortLookup(data, waveShaper, input);
            ++n2;
        }
    }

    private void checkShortLookup(short[] data, WaveShaper waveShaper, double input) {
        waveShaper.input.set(input);
        Synth.sleepForTicks(1);
        double expected = this.lookup(data, input);
        TestTable.assertEquals("wavetable output for " + input, expected, waveShaper.output.get(), 1.0E-4);
    }

    private double lookup(short[] data, double input) {
        double interp;
        double fractionalIndex = (double)(data.length - 1) * (input - -1.0) / 2.0;
        int index = (int)fractionalIndex;
        double fraction = fractionalIndex - (double)index;
        if (index < 0) {
            interp = data[0];
        } else if (index < data.length - 1) {
            short s1 = data[index];
            short s2 = data[index + 1];
            interp = (double)(s2 - s1) * fraction + (double)s1;
        } else {
            interp = data[data.length - 1];
        }
        return interp / 32768.0;
    }

    public void testLookupDouble() {
        double[] data = new double[]{23.4, -0.56, -87.298, 123.4, 84.2, -56.7};
        SynthTable table = new SynthTable(data.length);
        TestTable.assertEquals("Table length ", data.length, table.length());
        table.write(data);
        WaveShaper waveShaper = new WaveShaper();
        waveShaper.start();
        waveShaper.tablePort.setTable(table);
        double[] dArray = testInputs;
        int n = testInputs.length;
        int n2 = 0;
        while (n2 < n) {
            double input = dArray[n2];
            this.checkDoubleLookup(data, waveShaper, input);
            ++n2;
        }
    }

    private void checkDoubleLookup(double[] data, WaveShaper waveShaper, double input) {
        waveShaper.input.set(input);
        Synth.sleepForTicks(1);
        double expected = this.lookup(data, input);
        TestTable.assertEquals("wavetable output for " + input, expected, waveShaper.output.get(), 0.01);
    }

    private double lookup(double[] data, double input) {
        double interp;
        double fractionalIndex = (double)(data.length - 1) * (input - -1.0) / 2.0;
        int index = (int)fractionalIndex;
        double fraction = fractionalIndex - (double)index;
        if (index < 0) {
            interp = data[0];
        } else if (index < data.length - 1) {
            double s1 = data[index];
            double s2 = data[index + 1];
            interp = (s2 - s1) * fraction + s1;
        } else {
            interp = data[data.length - 1];
        }
        return interp;
    }
}

