/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.SignalChecker;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.TriangleOscillator;
import junit.framework.TestCase;

public class TestStartStop
extends TestCase {
    public void testStartStop() {
        Synth.startEngine(4);
        AddUnit add1 = new AddUnit();
        add1.inputA.set(0.1);
        add1.inputB.set(0.2);
        Synth.sleepForTicks(1);
        TestStartStop.assertEquals("unit not yet running", 0.0, add1.output.get(), 1.0E-4);
        add1.start();
        Synth.sleepForTicks(1);
        TestStartStop.assertEquals("unit running", 0.3, add1.output.get(), 1.0E-4);
        add1.stop();
        add1.inputA.set(0.4);
        add1.inputB.set(0.5);
        Synth.sleepForTicks(1);
        TestStartStop.assertEquals("unit stopped so should still have old output", 0.3, add1.output.get(), 1.0E-4);
        Synth.stopEngine();
    }

    public void testFlatOutput() {
        Synth.startEngine(4);
        short[] sArray = new short[128];
        sArray[0] = 2913;
        sArray[1] = 5825;
        sArray[2] = 8738;
        sArray[3] = 11650;
        sArray[4] = 14563;
        sArray[5] = 17476;
        sArray[6] = 20388;
        sArray[7] = 23301;
        sArray[8] = 26214;
        sArray[9] = 29126;
        sArray[10] = 32039;
        sArray[11] = 30583;
        sArray[12] = 27670;
        sArray[13] = 24757;
        sArray[14] = 21845;
        sArray[15] = 18932;
        sArray[16] = 16019;
        sArray[17] = 13107;
        sArray[18] = 10194;
        sArray[19] = 7282;
        sArray[20] = 4369;
        sArray[21] = 1456;
        sArray[22] = -1455;
        sArray[23] = -4368;
        sArray[24] = -7281;
        sArray[25] = -10193;
        sArray[26] = -13106;
        sArray[27] = -16018;
        sArray[28] = -18931;
        sArray[29] = -21844;
        sArray[30] = -24756;
        sArray[31] = -27669;
        sArray[32] = -30582;
        sArray[33] = -32038;
        sArray[34] = -29125;
        sArray[35] = -26213;
        sArray[36] = -23300;
        sArray[37] = -20387;
        sArray[38] = -17475;
        sArray[39] = -14562;
        sArray[40] = -11649;
        sArray[41] = -8737;
        sArray[42] = -5824;
        sArray[43] = -2912;
        sArray[45] = 2913;
        sArray[46] = 5825;
        sArray[47] = 8738;
        sArray[48] = 11650;
        sArray[49] = 14563;
        sArray[50] = 17476;
        sArray[51] = 20388;
        sArray[52] = 23301;
        sArray[53] = 26214;
        sArray[54] = 29126;
        sArray[55] = 32039;
        sArray[56] = 30583;
        sArray[57] = 27670;
        sArray[58] = 24757;
        sArray[59] = 21845;
        sArray[60] = 18932;
        sArray[61] = 16019;
        sArray[62] = 13107;
        sArray[63] = 10194;
        sArray[64] = 10194;
        sArray[65] = 10194;
        sArray[66] = 10194;
        sArray[67] = 10194;
        sArray[68] = 10194;
        sArray[69] = 10194;
        sArray[70] = 10194;
        sArray[71] = 10194;
        sArray[72] = 10194;
        sArray[73] = 10194;
        sArray[74] = 10194;
        sArray[75] = 10194;
        sArray[76] = 10194;
        sArray[77] = 10194;
        sArray[78] = 10194;
        sArray[79] = 10194;
        sArray[80] = 10194;
        sArray[81] = 10194;
        sArray[82] = 10194;
        sArray[83] = 10194;
        sArray[84] = 10194;
        sArray[85] = 10194;
        sArray[86] = 10194;
        sArray[87] = 10194;
        sArray[88] = 10194;
        sArray[89] = 10194;
        sArray[90] = 10194;
        sArray[91] = 10194;
        sArray[92] = 10194;
        sArray[93] = 10194;
        sArray[94] = 10194;
        sArray[95] = 10194;
        sArray[96] = 10194;
        sArray[97] = 10194;
        sArray[98] = 10194;
        sArray[99] = 10194;
        sArray[100] = 10194;
        sArray[101] = 10194;
        sArray[102] = 10194;
        sArray[103] = 10194;
        sArray[104] = 10194;
        sArray[105] = 10194;
        sArray[106] = 10194;
        sArray[107] = 10194;
        sArray[108] = 10194;
        sArray[109] = 10194;
        sArray[110] = 10194;
        sArray[111] = 10194;
        sArray[112] = 10194;
        sArray[113] = 10194;
        sArray[114] = 10194;
        sArray[115] = 10194;
        sArray[116] = 10194;
        sArray[117] = 10194;
        sArray[118] = 10194;
        sArray[119] = 10194;
        sArray[120] = 10194;
        sArray[121] = 10194;
        sArray[122] = 10194;
        sArray[123] = 10194;
        sArray[124] = 10194;
        sArray[125] = 10194;
        sArray[126] = 10194;
        sArray[127] = 10194;
        short[] image = sArray;
        TriangleOscillator osc1 = new TriangleOscillator();
        TriangleOscillator osc2 = new TriangleOscillator();
        double freq = Synth.getFrameRate() / 45.0;
        osc1.frequency.set(freq);
        osc2.frequency.set(freq);
        int framesPerTick = Synth.getFramesPerTick();
        int now = Synth.getTickCount();
        osc1.stop(now + 1);
        osc2.stop(now + 1);
        SignalChecker checker = new SignalChecker();
        checker.checkUnits(osc1, osc2, image, framesPerTick * 2);
        Synth.stopEngine();
    }

    public void testDoubleRun() {
        Synth.startEngine(4);
        AddUnit add1 = new AddUnit();
        add1.start();
        add1.inputA.set(0.4);
        add1.inputB.set(0.5);
        Synth.sleepForTicks(1);
        TestStartStop.assertEquals("unit running", 0.9, add1.output.get(), 1.0E-4);
        Synth.stopEngine();
        Synth.startEngine(4);
        add1.inputA.set(0.2);
        add1.inputB.set(0.1);
        Synth.sleepForTicks(1);
        TestStartStop.assertEquals("unit stopped so should still have old output", 0.9, add1.output.get(), 1.0E-4);
        Synth.stopEngine();
    }
}

