/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import junit.framework.TestCase;

public class TestInitTerm
extends TestCase {
    private void checkAdder(AddUnit adder) {
        adder.start();
        adder.inputA.set(0.1);
        adder.inputB.set(0.2);
        Synth.sleepForTicks(1);
        TestInitTerm.assertEquals("unit adding", 0.3, adder.output.get(), 1.0E-4);
        adder.inputA.set(0.5);
        adder.inputB.set(0.3);
        Synth.sleepForTicks(1);
        TestInitTerm.assertEquals("unit adding", 0.8, adder.output.get(), 1.0E-4);
        adder.stop();
    }

    public void testSingleRun() {
        Synth.startEngine(4);
        AddUnit adder = new AddUnit();
        this.checkAdder(adder);
        Synth.stopEngine();
    }

    public void testMultipleRuns() {
        int i = 0;
        while (i < 10) {
            Synth.startEngine(4);
            AddUnit adder = new AddUnit();
            this.checkAdder(adder);
            Synth.stopEngine();
            Runtime.getRuntime().gc();
            ++i;
        }
    }

    private void checkNestedRuns(int count) {
        if (count > 0) {
            Synth.startEngine(4);
            AddUnit add1 = new AddUnit();
            this.checkAdder(add1);
            this.checkNestedRuns(count - 1);
            this.checkAdder(add1);
            Synth.stopEngine();
            Runtime.getRuntime().gc();
        }
    }

    public void testNestedRuns() {
        this.checkNestedRuns(10);
    }

    public void testGarbageCollectStaleUnit() {
        Synth.startEngine(4);
        AddUnit add1 = new AddUnit();
        this.checkAdder(add1);
        Synth.stopEngine();
        Synth.startEngine(4);
        AddUnit add2 = new AddUnit();
        Runtime.getRuntime().gc();
        Runtime.getRuntime().gc();
        Runtime.getRuntime().gc();
        this.checkAdder(add2);
        Synth.stopEngine();
    }

    public void testDeleteStaleUnit() {
        Synth.startEngine(4);
        AddUnit add1 = new AddUnit();
        this.checkAdder(add1);
        TestInitTerm.assertEquals("Calls to startEngine/stopEngine not balanced.", 1, Synth.getSharedContext().getOpenCount());
        Synth.stopEngine();
        Synth.startEngine(4);
        AddUnit add2 = new AddUnit();
        try {
            add1.delete();
            TestInitTerm.assertTrue("delete should blow chunks", false);
        }
        catch (SynthException e) {
            System.out.println("Caught " + e + ". GOOD!");
        }
        this.checkAdder(add2);
        Synth.stopEngine();
    }
}

