/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import junit.framework.TestCase;

public class TestErrors
extends TestCase {
    public void testStopAfterEngine() {
        Synth.startEngine(4);
        SineOscillator osc = new SineOscillator();
        osc.start();
        Synth.sleepForTicks(2);
        Synth.stopEngine();
        int result = 0;
        try {
            osc.stop();
            result = 2;
        }
        catch (SynthException e) {
            System.out.println("SUCCESS - Caught " + e + ", GOOD!");
            TestErrors.assertTrue("catch host init failed", e.getMessage().contains("Host initialization failed."));
            result = 3;
        }
        TestErrors.assertEquals("caught exception", 3, result);
    }

    public int checkOverIndexConnect(int part1, int part2) {
        int result = 0;
        SineOscillator osc1 = new SineOscillator();
        SineOscillator osc2 = new SineOscillator();
        try {
            osc1.output.connect(part1, osc2.frequency, part2);
        }
        catch (SynthException e) {
            System.out.println("SUCCESS - part1 = " + part1 + ", part2 = " + part2 + ", Caught " + e + ", GOOD!");
            TestErrors.assertTrue("catch host init failed", e.getMessage().contains("Invalid partnum."));
            ++result;
        }
        Synth.sleepForTicks(2);
        return result;
    }

    public void testOverIndexConnect() {
        Synth.startEngine(4);
        int result = this.checkOverIndexConnect(0, 0);
        result += this.checkOverIndexConnect(0, 1);
        TestErrors.assertEquals("did not catch right number of exceptions", 2, result += this.checkOverIndexConnect(1, 0));
        Synth.stopEngine();
    }

    public int checkOverIndexSet(int part) {
        int result = 0;
        SineOscillator osc1 = new SineOscillator();
        try {
            osc1.frequency.set(660.0, part);
        }
        catch (SynthException e) {
            System.out.println("SUCCESS - part = " + part + ", Caught " + e + ", GOOD!");
            TestErrors.assertTrue("catch host init failed", e.getMessage().contains("Invalid partnum."));
            ++result;
        }
        Synth.sleepForTicks(2);
        return result;
    }

    public void testOverIndexSet() {
        Synth.startEngine(4);
        int result = this.checkOverIndexSet(0);
        TestErrors.assertEquals("did not catch right number of exceptions", 1, result += this.checkOverIndexSet(1));
        Synth.stopEngine();
    }
}

