/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthDistributor;
import junit.framework.TestCase;

public class TestConnections
extends TestCase {
    AddUnit add1;
    AddUnit add2;
    AddUnit add3;

    @Override
    protected void setUp() throws Exception {
        Synth.startEngine(4);
        this.add1 = new AddUnit();
        this.add2 = new AddUnit();
        this.add3 = new AddUnit();
        this.add1.start();
        this.add2.start();
        this.add3.start();
        this.add1.inputA.set(0.1);
        this.add1.inputB.set(0.2);
        this.add2.inputA.set(0.4);
        this.add2.inputB.set(0.8);
        this.add3.inputA.set(1.6);
        this.add3.inputB.set(3.2);
    }

    @Override
    protected void tearDown() throws Exception {
        TestConnections.assertEquals("Calls to startEngine/stopEngine not balanced.", 1, Synth.getSharedContext().getOpenCount());
        Synth.stopEngine();
    }

    public void testSet() {
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("set inputs of adder", 0.3, this.add1.output.get(), 1.0E-4);
    }

    public void testConnect() {
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("set inputs of adder", 0.3, this.add1.output.get(), 1.0E-4);
        TestConnections.assertEquals("set inputs of adder", 1.2, this.add2.output.get(), 1.0E-4);
        this.add1.output.connect(this.add2.inputB);
        Synth.sleepForTicks(2);
        TestConnections.assertEquals("connection should not change output", 0.3, this.add1.output.get(), 1.0E-4);
        TestConnections.assertEquals("replace set value with output", 0.7000000000000001, this.add2.output.get(), 1.0E-4);
        this.add1.output.disconnect();
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("still the same", 0.3, this.add1.output.get(), 1.0E-4);
        TestConnections.assertEquals("should revert to original set() value", 1.2, this.add2.output.get(), 1.0E-4);
    }

    public void testDisplace() {
        this.add1.output.connect(this.add2.inputB);
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("replace set value with output", 0.7, this.add2.output.get(), 1.0E-4);
        TestConnections.assertEquals("add3 value", 4.800000000000001, this.add3.output.get(), 1.0E-4);
        this.add3.output.connect(this.add2.inputB);
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("now be driven by add3", 5.200000000000001, this.add2.output.get(), 1.0E-4);
    }

    public void WILLNOTFIXtestSynthDistributor1() {
        SynthDistributor distributor = new SynthDistributor("amp");
        distributor.connect(this.add1.inputA);
        distributor.connect(this.add2.inputA);
        distributor.connect(this.add3.inputA);
        double value1 = 4.0;
        distributor.set(value1);
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("should all get value from distributor", value1 + this.add1.inputB.get(), this.add1.output.get(), 1.0E-4);
        TestConnections.assertEquals("should all get value from distributor", value1 + this.add2.inputB.get(), this.add2.output.get(), 1.0E-4);
        TestConnections.assertEquals("should all get value from distributor", value1 + this.add3.inputB.get(), this.add3.output.get(), 1.0E-4);
        this.add2.inputA.disconnect();
        double value2 = 7.0;
        distributor.set(value2);
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("should all get value from distributor", value2 + this.add1.inputB.get(), this.add1.output.get(), 1.0E-4);
        TestConnections.assertEquals("should not get value from distributor", value1 + this.add2.inputB.get(), this.add2.output.get(), 1.0E-4);
        TestConnections.assertEquals("should all get value from distributor", value2 + this.add3.inputB.get(), this.add3.output.get(), 1.0E-4);
    }

    public void testSynthDistributor2() {
        SynthDistributor distributor = new SynthDistributor("amp");
        distributor.connect(this.add1.inputA);
        distributor.connect(this.add2.inputA);
        distributor.connect(this.add3.inputA);
        double value1 = 4.0;
        distributor.set(value1);
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("should all get value from distributor", value1 + this.add1.inputB.get(), this.add1.output.get(), 1.0E-4);
        TestConnections.assertEquals("should all get value from distributor", value1 + this.add2.inputB.get(), this.add2.output.get(), 1.0E-4);
        TestConnections.assertEquals("should all get value from distributor", value1 + this.add3.inputB.get(), this.add3.output.get(), 1.0E-4);
        distributor.disconnect(this.add2.inputA);
        double value2 = 7.0;
        distributor.set(value2);
        Synth.sleepForTicks(1);
        TestConnections.assertEquals("should all get value from distributor", value2 + this.add1.inputB.get(), this.add1.output.get(), 1.0E-4);
        TestConnections.assertEquals("should not get value from distributor", value1 + this.add2.inputB.get(), this.add2.output.get(), 1.0E-4);
        TestConnections.assertEquals("should all get value from distributor", value2 + this.add3.inputB.get(), this.add3.output.get(), 1.0E-4);
    }

    public void WILLNOTFIXtestSynthDistributorDelete() {
        SynthDistributor distributor = new SynthDistributor("amp");
        distributor.connect(this.add1.inputA);
        distributor.connect(this.add2.inputA);
        distributor.connect(this.add3.inputA);
        distributor.set(3.0);
        Synth.sleepForTicks(1);
        this.add2.inputA.disconnect();
        this.add2.delete();
        Synth.sleepForTicks(1);
        distributor.set(4.0);
    }
}

