/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import java.util.Enumeration;
import java.util.Vector;

public class SharedSleeper {
    int currentIndex = 0;
    Vector threads = new Vector();
    int numWaiting = 0;

    public synchronized void addThread(Thread thread) {
        if (!this.threads.contains(thread)) {
            this.threads.addElement(thread);
        }
    }

    public synchronized void addThread() {
        this.addThread(Thread.currentThread());
    }

    public synchronized void removeThread() {
        Thread current = Thread.currentThread();
        this.threads.removeElement(current);
        this.notifyAll();
    }

    public void setIndex(int index) {
        this.currentIndex = index;
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public int bumpIndex() {
        int nextIndex = this.currentIndex + 1;
        return nextIndex;
    }

    private synchronized boolean addWaiter() {
        Enumeration e = this.threads.elements();
        while (e.hasMoreElements()) {
            Thread t = (Thread)e.nextElement();
            if (t.isAlive()) continue;
            this.threads.removeElement(t);
        }
        ++this.numWaiting;
        return this.numWaiting >= this.threads.size();
    }

    private synchronized void removeWaiter() {
        --this.numWaiting;
    }

    private synchronized int waitForBump() throws InterruptedException {
        boolean lastWaiter = this.addWaiter();
        try {
            if (lastWaiter) {
                this.currentIndex = this.bumpIndex();
                this.notifyAll();
            } else {
                this.wait(100L);
            }
        }
        finally {
            this.removeWaiter();
        }
        return this.currentIndex;
    }

    public int sleepUntilIndex(int desiredIndex) throws InterruptedException {
        int thisIndex = this.currentIndex;
        Thread thread = Thread.currentThread();
        int oldPriority = thread.getPriority();
        thread.setPriority(1);
        try {
            thisIndex = this.currentIndex;
            while (desiredIndex - this.currentIndex > 0) {
                Thread.yield();
                thisIndex = this.waitForBump();
            }
        }
        finally {
            thread.setPriority(oldPriority);
        }
        return thisIndex;
    }
}

