/*
 * Decompiled with CFR 0.152.
 */
package com.jsynx.inprogress;

import com.jsyn.data.SequentialData;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import javax.swing.JComponent;

public class SequentialDataView
extends JComponent {
    private SequentialData data;
    private int channel;
    private double minValue;
    private double maxValue;
    HashMap<String, Integer> markers = new HashMap();

    public void addMarker(String name, int position) {
        this.markers.put(name, position);
    }

    public void clearMarkers() {
        this.markers.clear();
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
        this.repaint();
    }

    public SequentialData getData() {
        return this.data;
    }

    public void setData(SequentialData data) {
        this.data = data;
        this.measureRange();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.data != null) {
            int x;
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
            g.setColor(this.getForeground());
            int oldX = 0;
            int oldY = h;
            int numSamples = this.data.getNumFrames();
            double xScalar = (double)w / (double)numSamples;
            double yScalar = (double)h / (this.maxValue - this.minValue);
            int i = 0;
            while (i < numSamples) {
                x = (int)((double)i * xScalar);
                int y = (int)((this.maxValue - this.data.readDouble(i)) * yScalar);
                g.drawLine(oldX, oldY, x, y);
                oldX = x;
                oldY = y;
                ++i;
            }
            for (Integer value : this.markers.values()) {
                x = (int)((double)value.intValue() * xScalar);
                g.setColor(Color.red);
                g.drawLine(x, 0, x, h);
            }
        } else {
            g.drawString("No data", 20, 40);
        }
    }

    private void measureRange() {
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.MIN_VALUE;
        int i = 0;
        while (i < this.data.getNumFrames()) {
            double val = this.data.readDouble(i);
            if (val > this.maxValue) {
                this.maxValue = val;
            }
            if (val < this.minValue) {
                this.minValue = val;
            }
            ++i;
        }
    }
}

