/*
 * Decompiled with CFR 0.152.
 */
package com.jsynx.inprogress;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ScrollingEdgeDisplay
extends JComponent {
    private BufferedImage[] images = new BufferedImage[2];
    private Graphics2D[] g = new Graphics2D[2];
    private int imageWidth;
    private int columnCursor;
    private int imageIndex;
    private int imageHeight;

    public ScrollingEdgeDisplay() {
        this.setPreferredSize(new Dimension(400, 60));
        this.setForeground(Color.BLACK);
        this.setBackground(Color.YELLOW);
        this.createImages();
    }

    private void createImages() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (w > 0 && h > 0) {
            this.imageWidth = w;
            this.imageHeight = h;
            this.images[0] = new BufferedImage(w, h, 2);
            this.g[0] = this.images[0].createGraphics();
            this.g[0].setColor(Color.BLACK);
            this.g[0].fillRect(0, 0, w, h);
            this.images[1] = new BufferedImage(w, h, 2);
            this.g[1] = this.images[1].createGraphics();
            this.g[1].setColor(Color.BLACK);
            this.g[1].fillRect(0, 0, w, h);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.imageWidth != this.getWidth() || this.imageHeight != this.getHeight()) {
            this.createImages();
        }
        if (this.images[0] == null) {
            g.drawString("no images", 30, 30);
        } else {
            g.drawImage(this.images[this.imageIndex ^ 1], 0 - this.columnCursor, 0, this);
            g.drawImage(this.images[this.imageIndex], this.imageWidth - this.columnCursor, 0, this);
        }
    }

    public void drawRGB(int y, int RGB) {
        this.images[this.imageIndex].setRGB(this.columnCursor, y, RGB);
    }

    public void advanceColumn() {
        ++this.columnCursor;
        if (this.columnCursor >= this.imageWidth) {
            this.columnCursor = 0;
            this.imageIndex ^= 1;
        }
        this.g[this.imageIndex].drawLine(this.columnCursor, 0, this.columnCursor, this.imageHeight);
        this.repaint();
    }
}

