/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.data.FloatSample;
import com.jsyn.util.AutoCorrelator;
import com.jsyn.util.SampleLoader;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class TestSampleLoader
extends TestCase {
    private static final File sampleDir = new File("samples");

    public FloatSample checkSampleLoader(String name, int channels, int frames, double frameRate, int sustainBegin, int sustainEnd) throws IOException {
        System.out.println("Test " + name);
        File sampleFile = new File(sampleDir, name);
        FloatSample sample = SampleLoader.loadFloatSample(sampleFile);
        TestSampleLoader.assertEquals("channelsPerFrame", channels, sample.getChannelsPerFrame());
        TestSampleLoader.assertEquals("num frames", frames, sample.getNumFrames());
        TestSampleLoader.assertEquals("frame rate", frameRate, sample.getFrameRate(), 1.0);
        TestSampleLoader.assertEquals("sustainBegin", sustainBegin, sample.getSustainBegin());
        TestSampleLoader.assertEquals("sustainEnd", sustainEnd, sample.getSustainEnd());
        return sample;
    }

    public FloatSample checkSampleLoader(String name, int channels, int frames, double frameRate) throws IOException {
        return this.checkSampleLoader(name, channels, frames, frameRate, -1, -1);
    }

    public void testBasicMono() throws IOException {
        this.checkSampleLoader("sine_400_mono.wav", 1, 234305, 48000.0);
    }

    public void testMarkers() throws IOException {
        FloatSample sample = this.checkSampleLoader("cello_markers.wav", 1, 205376, 44100.0, 71680, 160000);
        TestSampleLoader.assertEquals("num markers", 2, sample.getMarkerCount());
        TestSampleLoader.assertEquals("marker position", 71680, sample.getMarker((int)0).position);
        TestSampleLoader.assertEquals("marker position", 160000, sample.getMarker((int)1).position);
    }

    public void testMatrixStereo() throws IOException {
        double frameRate = 44100.0;
        String[] fileTypes = new String[]{"wavex", "wav", "aif"};
        String[] dataFormats = new String[]{"i16", "i24", "i32", "f32"};
        String[] stringArray = fileTypes;
        int n = fileTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String[] stringArray2 = dataFormats;
            int n3 = dataFormats.length;
            int n4 = 0;
            while (n4 < n3) {
                String format = stringArray2[n4];
                FloatSample sample = this.checkSampleLoader("sine_200_300_" + format + "." + type, 2, 88200, frameRate);
                this.checkSineFrequency(sample, frameRate / 200.0, 0);
                this.checkSineFrequency(sample, frameRate / 300.0, 1);
                ++n4;
            }
            ++n2;
        }
    }

    public void testMatrixMono() throws IOException {
        double frameRate = 44100.0;
        String[] fileTypes = new String[]{"wav", "aifc"};
        String[] dataFormats = new String[]{"i16"};
        String[] stringArray = fileTypes;
        int n = fileTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String[] stringArray2 = dataFormats;
            int n3 = dataFormats.length;
            int n4 = 0;
            while (n4 < n3) {
                String format = stringArray2[n4];
                FloatSample sample = this.checkSampleLoader("sine_400_loop_" + format + "." + type, 1, 132300, frameRate, 27675, 36381);
                this.checkSineFrequency(sample, frameRate / 400.0, 0);
                ++n4;
            }
            ++n2;
        }
    }

    private void checkSineFrequency(FloatSample sample, double period, int channel) {
        AutoCorrelator auto = new AutoCorrelator(8192);
        int index = channel;
        int channelsPerFrame = sample.getChannelsPerFrame();
        int i = 0;
        while (i < sample.getNumFrames()) {
            auto.addSample(sample.readDouble(index));
            index += channelsPerFrame;
            ++i;
        }
        double confidence = auto.getConfidence();
        TestSampleLoader.assertTrue("confidence = " + confidence, confidence > 0.8);
        TestSampleLoader.assertEquals("measure sine period", period, auto.getPeriod(), 1.0);
    }

    public void testUnsupportedFiles() {
        this.checkUnsupportedFile("sine_400_u8.aif");
        this.checkUnsupportedFile("sine_400_u8.wav");
        this.checkUnsupportedFile("sine_400_s8.aif");
        this.checkUnsupportedFile("sine_400_ulaw.aif");
        this.checkUnsupportedFile("sine_400_ulaw.wav");
    }

    private void checkUnsupportedFile(String name) {
        try {
            System.out.println("checkUnsupportedFile: " + name);
            File sampleFile = new File(sampleDir, name);
            SampleLoader.loadFloatSample(sampleFile);
            TestSampleLoader.assertTrue("should not be able to read " + name, false);
        }
        catch (IOException exc) {
            TestSampleLoader.assertTrue("message has Only", exc.getMessage().startsWith("Only"));
        }
    }
}

