/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.tutorial;

import com.jsyn.tutorial.Siren;
import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view102.PortFader;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;

public class TUT_Siren
extends Applet {
    Siren siren;
    LineOut lineOut;
    PortFader centerFader;
    PortFader amplitudeFader;
    PortFader modFreqFader;
    PortFader modDepthFader;

    public static void main(String[] args) {
        TUT_Siren applet = new TUT_Siren();
        AppletFrame frame = new AppletFrame("Test Siren", applet);
        frame.resize(500, 200);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        try {
            Synth.startEngine(0);
            this.siren = new Siren();
            this.lineOut = new LineOut();
            this.siren.output.connect(0, this.lineOut.input, 0);
            this.siren.output.connect(0, this.lineOut.input, 1);
            this.centerFader = new PortFader(this.siren.frequency, 600.0, 0.0, 1000.0);
            this.add(this.centerFader);
            this.amplitudeFader = new PortFader(this.siren.amplitude, 0.5, 0.0, 1.0);
            this.add(this.amplitudeFader);
            this.modFreqFader = new PortFader(this.siren.modulationRate, 0.1, 0.0, 4.0);
            this.add(this.modFreqFader);
            this.modDepthFader = new PortFader(this.siren.modulationDepth, 300.0, 0.0, 400.0);
            this.add(this.modDepthFader);
            this.getParent().validate();
            this.getToolkit().sync();
            this.siren.start();
            this.lineOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        try {
            this.removeAll();
            Synth.stopEngine();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }
}

