/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.tutorial;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.EnvelopePlayer;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthEnvelope;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view102.LabelledFader;
import com.softsynth.jsyn.view102.Tweakable;
import java.applet.Applet;
import java.awt.Component;

public class TUT_SeqBuffered
extends Applet
implements Tweakable {
    TickerThread thread1;
    TickerThread thread2;
    boolean addAdvanceFader = false;
    LabelledFader advanceFader;
    int advanceTime;
    static final double DEFAULT_ADVANCE = 0.5;
    boolean go = false;

    public static void main(String[] args) {
        TUT_SeqBuffered applet = new TUT_SeqBuffered();
        applet.addAdvanceFader = true;
        AppletFrame frame = new AppletFrame("Play Sequence using Event Buffer", applet);
        frame.resize(600, 120);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        try {
            Synth.startEngine(0);
            int startTime = Synth.getTickCount() + (int)Synth.getTickRate();
            int duration = (int)(Synth.getTickRate() / 10.0);
            this.thread1 = this.makeThread();
            this.thread2 = this.makeThread();
            int measure = 240;
            this.thread1.setup(startTime, measure, 2, 1.0);
            this.thread2.setup(startTime, measure, 4, 5.333333333333333);
            if (this.addAdvanceFader) {
                this.advanceFader = new LabelledFader(this, 2, "Advance Time", 0.5, 0.0, 1.0);
                this.add(this.advanceFader);
            }
            this.go = true;
            this.thread1.start();
            this.thread2.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    TickerThread makeThread() {
        return new TickerThread();
    }

    @Override
    public void tweak(int targetIndex, double val) {
        switch (targetIndex) {
            case 1: {
                this.advanceTime = (int)(Synth.getTickRate() * val);
            }
        }
    }

    @Override
    public void stop() {
        this.go = false;
        System.out.println("Stopping engine" + this);
        Synth.stopEngine();
        System.out.println("Stopped" + this);
    }

    class TickerThread
    extends Thread {
        SynthEnvelope envData;
        EnvelopePlayer envPlayer;
        TriangleOscillator osc;
        LineOut lineOut;
        int startTime;
        int measure;
        int duration;
        int notesPerMeasure;
        double fundamental = 400.0;
        double transpose;
        int pitchIndex = 0;
        double[] series = new double[]{1.0, 1.25, 1.3333333333333333, 1.5};

        public TickerThread() {
            this.osc = new TriangleOscillator();
            this.envPlayer = new EnvelopePlayer();
            this.lineOut = new LineOut();
            this.envPlayer.output.connect(this.osc.amplitude);
            double[] data = new double[]{0.005, 1.0, 0.01, 0.0};
            this.envData = new SynthEnvelope(data);
            this.osc.output.connect(0, this.lineOut.input, 0);
            this.osc.output.connect(0, this.lineOut.input, 1);
            this.osc.start();
            this.envPlayer.start();
            this.lineOut.start();
        }

        void setup(int startTime, int measure, int notesPerMeasure, double transpose) {
            this.startTime = startTime;
            this.notesPerMeasure = notesPerMeasure;
            this.transpose = transpose;
            this.duration = measure / notesPerMeasure;
        }

        double nextFrequency() {
            double frequency = this.transpose * this.fundamental * this.series[this.pitchIndex++];
            if (this.pitchIndex > this.notesPerMeasure || this.pitchIndex >= this.series.length) {
                this.pitchIndex = 0;
            }
            return frequency;
        }

        void bang(int time) {
            this.osc.frequency.set(this.nextFrequency());
            this.envPlayer.amplitude.set(0.5);
            this.envPlayer.envelopePort.clear(time);
            this.envPlayer.envelopePort.queue(time, this.envData);
        }

        void bang() {
            this.bang(Synth.getTickCount());
        }

        public void playNotes() {
            TUT_SeqBuffered.this.advanceTime = (int)(Synth.getTickRate() * 0.5);
            Synth.sleepUntilTick(this.startTime - TUT_SeqBuffered.this.advanceTime);
            int nextTime = this.startTime;
            while (TUT_SeqBuffered.this.go) {
                this.bang(nextTime);
                Synth.sleepUntilTick((nextTime += this.duration) - TUT_SeqBuffered.this.advanceTime);
            }
        }

        @Override
        public void run() {
            try {
                this.playNotes();
            }
            catch (SynthException e) {
                System.err.println("run() caught " + e);
            }
        }
    }
}

