/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class ASCIIMusicKeyboard
extends JPanel {
    private JCheckBox sustainBox;
    private JButton focusButton;
    public static final String PENTATONIC_KEYS = "zxcvbasdfgqwert12345";
    public static final String SEPTATONIC_KEYS = "zxcvbnmasdfghjqwertyu1234567890";
    private String keyboardLayout = "zxcvbnmasdfghjqwertyu1234567890";
    private int basePitch = 48;
    private KeyListener keyListener;
    private JLabel countLabel;
    private int onCount;
    private int offCount;
    private int pressedCount;
    private int releasedCount;
    private HashSet<Integer> pressedKeys = new HashSet();
    private HashSet<Integer> onKeys = new HashSet();

    public ASCIIMusicKeyboard() {
        this.focusButton = new JButton("Click here to play ASCII keys.");
        this.focusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        this.keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                char key = e.getKeyChar();
                int idx = ASCIIMusicKeyboard.this.keyboardLayout.indexOf(key);
                System.out.println("keyPressed " + idx);
                if (idx >= 0 && !ASCIIMusicKeyboard.this.pressedKeys.contains(idx)) {
                    ASCIIMusicKeyboard.this.keyOn(ASCIIMusicKeyboard.this.convertIndexToPitch(idx));
                    ASCIIMusicKeyboard aSCIIMusicKeyboard = ASCIIMusicKeyboard.this;
                    aSCIIMusicKeyboard.onCount = aSCIIMusicKeyboard.onCount + 1;
                    ASCIIMusicKeyboard.this.pressedKeys.add(idx);
                    ASCIIMusicKeyboard.this.onKeys.add(idx);
                }
                ASCIIMusicKeyboard aSCIIMusicKeyboard = ASCIIMusicKeyboard.this;
                aSCIIMusicKeyboard.pressedCount = aSCIIMusicKeyboard.pressedCount + 1;
                ASCIIMusicKeyboard.this.updateCountLabel();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                char key = e.getKeyChar();
                int idx = ASCIIMusicKeyboard.this.keyboardLayout.indexOf(key);
                System.out.println("keyReleased " + idx);
                if (idx >= 0) {
                    if (!ASCIIMusicKeyboard.this.sustainBox.isSelected()) {
                        ASCIIMusicKeyboard.this.noteOffInternal(idx);
                        ASCIIMusicKeyboard.this.onKeys.remove(idx);
                    }
                    ASCIIMusicKeyboard.this.pressedKeys.remove(idx);
                }
                ASCIIMusicKeyboard aSCIIMusicKeyboard = ASCIIMusicKeyboard.this;
                aSCIIMusicKeyboard.releasedCount = aSCIIMusicKeyboard.releasedCount + 1;
                ASCIIMusicKeyboard.this.updateCountLabel();
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        };
        this.focusButton.addKeyListener(this.keyListener);
        this.add(this.focusButton);
        this.sustainBox = new JCheckBox("sustain");
        this.sustainBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!ASCIIMusicKeyboard.this.sustainBox.isSelected()) {
                    for (Integer noteIndex : ASCIIMusicKeyboard.this.onKeys) {
                        ASCIIMusicKeyboard.this.noteOffInternal(noteIndex);
                    }
                    ASCIIMusicKeyboard.this.onKeys.clear();
                }
            }
        });
        this.add(this.sustainBox);
        this.sustainBox.addKeyListener(this.keyListener);
        this.countLabel = new JLabel("0");
        this.add(this.countLabel);
    }

    private void noteOffInternal(int idx) {
        this.keyOff(this.convertIndexToPitch(idx));
        ++this.offCount;
    }

    protected void updateCountLabel() {
        this.countLabel.setText(String.valueOf(this.onCount) + "/" + this.offCount + ", " + this.pressedCount + "/" + this.releasedCount);
    }

    public int convertIndexToPitch(int keyIndex) {
        int[] nArray = new int[7];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 9;
        nArray[6] = 11;
        int[] scale = nArray;
        int octave = keyIndex / scale.length;
        int idx = keyIndex % scale.length;
        int pitch = octave * 12 + scale[idx];
        return pitch + this.basePitch;
    }

    public abstract void keyOff(int var1);

    public abstract void keyOn(int var1);

    public String getKeyboardLayout() {
        return this.keyboardLayout;
    }

    public void setKeyboardLayout(String keyboardLayout) {
        this.keyboardLayout = keyboardLayout;
    }

    public int getBasePitch() {
        return this.basePitch;
    }

    public void setBasePitch(int basePitch) {
        this.basePitch = basePitch;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }
}

