/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.ports.ConnectableInput;
import com.jsyn.ports.ConnectableOutput;
import com.jsyn.ports.InputMixingBlockPart;
import com.jsyn.ports.PortBlockPart;
import com.jsyn.ports.SettablePort;
import com.jsyn.ports.UnitBlockPort;
import com.jsyn.ports.UnitOutputPort;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;
import java.io.PrintStream;

public class UnitInputPort
extends UnitBlockPort
implements ConnectableInput,
SettablePort {
    private double minimum = 0.0;
    private double maximum = 1.0;
    private double defaultValue = 0.0;
    private double[] setValues;

    public UnitInputPort(int numParts, String name, double defaultValue) {
        super(numParts, name, defaultValue);
        this.setDefault(defaultValue);
        this.setValues = new double[numParts];
        int i = 0;
        while (i < numParts) {
            this.setValues[i] = defaultValue;
            ++i;
        }
    }

    public UnitInputPort(String name, double defaultValue) {
        this(1, name, defaultValue);
    }

    public UnitInputPort(String name) {
        this(1, name, 0.0);
    }

    public UnitInputPort(int numParts, String name) {
        this(numParts, name, 0.0);
    }

    @Override
    protected void makeParts(int numParts, double defaultValue) {
        this.parts = new InputMixingBlockPart[numParts];
        int i = 0;
        while (i < numParts) {
            this.parts[i] = new InputMixingBlockPart(this, defaultValue);
            ++i;
        }
    }

    @Override
    public void pullData(long frameCount, int start, int limit) {
        PortBlockPart[] portBlockPartArray = this.parts;
        int n = this.parts.length;
        int n2 = 0;
        while (n2 < n) {
            PortBlockPart part = portBlockPartArray[n2];
            ((InputMixingBlockPart)part).pullData(frameCount, start, limit);
            ++n2;
        }
    }

    @Override
    protected void setValueInternal(int partNum, double value) {
        super.setValueInternal(partNum, value);
        this.setValues[partNum] = value;
    }

    public void set(double value) {
        this.set(0, value);
    }

    public void set(final int partNum, final double value) {
        this.setValues[partNum] = value;
        this.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                UnitInputPort.this.setValueInternal(partNum, value);
            }
        });
    }

    public void set(double value, TimeStamp time) {
        this.set(0, value, time);
    }

    public void set(double value, double time) {
        this.set(0, value, time);
    }

    public void set(int partNum, double value, double time) {
        this.set(partNum, value, new TimeStamp(time));
    }

    @Override
    public void set(final int partNum, final double value, TimeStamp timeStamp) {
        this.getValue(partNum);
        this.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                UnitInputPort.this.setValueInternal(partNum, value);
            }
        });
    }

    @Override
    public double get(int partNum) {
        return this.setValues[partNum];
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public double getDefault() {
        return this.defaultValue;
    }

    public void setDefault(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setup(double minimum, double value, double maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        this.setDefault(value);
        this.set(value);
    }

    public void setup(UnitInputPort other) {
        this.setup(other.getMinimum(), other.getDefault(), other.getMaximum());
    }

    public void connect(int thisPartNum, UnitOutputPort otherPort, int otherPartNum, TimeStamp timeStamp) {
        otherPort.connect(otherPartNum, this, thisPartNum, timeStamp);
    }

    public void connect(int thisPartNum, UnitOutputPort otherPort, int otherPartNum) {
        otherPort.connect(otherPartNum, this, thisPartNum);
    }

    public void connect(UnitOutputPort otherPort) {
        this.connect(0, otherPort, 0);
    }

    @Override
    public void connect(ConnectableOutput other) {
        other.connect(this);
    }

    public void disconnect(int thisPartNum, UnitOutputPort otherPort, int otherPartNum) {
        otherPort.disconnect(otherPartNum, this, thisPartNum);
    }

    @Override
    public PortBlockPart getPortBlockPart() {
        return this.parts[0];
    }

    public ConnectableInput getConnectablePart(int i) {
        return this.parts[i];
    }

    @Override
    public void disconnect(ConnectableOutput other) {
        other.disconnect(this);
    }

    public void printConnections(PrintStream out, int level) {
        PortBlockPart[] portBlockPartArray = this.parts;
        int n = this.parts.length;
        int n2 = 0;
        while (n2 < n) {
            PortBlockPart part = portBlockPartArray[n2];
            ((InputMixingBlockPart)part).printConnections(out, level);
            ++n2;
        }
    }
}

