/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.pieces.improv;

import com.jsyn.pieces.improv.MusicBeat;

public class BeatDetector
extends MusicBeat {
    private double confidence = 0.0;

    public void hit(double time) {
        if (this.confidence == 0.0) {
            this.confidence = 1.0E-4;
        } else {
            double newBeat = time - this.lastTime;
            this.period = this.period * this.confidence + newBeat * (1.0 - this.confidence);
            double error = (newBeat - this.period) / this.period;
            double errorSquared = error * error;
            double bc = (1.0 + this.confidence) * 0.5 - errorSquared;
            if (bc < 0.0) {
                bc = 0.0;
            }
            this.confidence = bc;
            System.out.printf("beat = %5.3f, conf = %5.3f\n", this.period, this.confidence);
        }
        this.lastTime = time;
    }

    public double getConfidence() {
        return this.confidence;
    }
}

