/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortControllerFactory;
import com.jsyn.unitgen.ImpulseOscillator;
import com.jsyn.unitgen.ImpulseOscillatorBL;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.Multiply;
import com.jsyn.unitgen.PulseOscillator;
import com.jsyn.unitgen.PulseOscillatorBL;
import com.jsyn.unitgen.RedNoise;
import com.jsyn.unitgen.SawtoothOscillator;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SawtoothOscillatorDPW;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SquareOscillator;
import com.jsyn.unitgen.SquareOscillatorBL;
import com.jsyn.unitgen.TriangleOscillator;
import com.jsyn.unitgen.UnitOscillator;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SeeOscillators
extends JApplet {
    private static final long serialVersionUID = -8315903842197137926L;
    private Synthesizer synth;
    private ArrayList<UnitOscillator> oscillators = new ArrayList();
    private LineOut lineOut;
    private AudioScope scope;
    private JPanel oscPanel;
    private Multiply oscGain;
    private ButtonGroup buttonGroup;
    private LinearRamp freqRamp;

    public static void main(String[] args) {
        SeeOscillators applet = new SeeOscillators();
        JAppletFrame frame = new JAppletFrame("ShowWaves", applet);
        frame.setSize(640, 500);
        frame.setVisible(true);
        frame.test();
        frame.validate();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.add("North", new JLabel("Show Oscillators in an AudioScope"));
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.oscGain.output);
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.getView().setShowControls(false);
        this.scope.start();
        this.add("Center", this.scope.getView());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridLayout(0, 1));
        this.add("South", southPanel);
        this.oscPanel = new JPanel();
        this.oscPanel.setLayout(new GridLayout(2, 5));
        southPanel.add(this.oscPanel);
        southPanel.add(PortControllerFactory.createExponentialPortSlider(this.freqRamp.input));
        southPanel.add(PortControllerFactory.createExponentialPortSlider(this.oscGain.inputB));
        this.oscPanel.validate();
        this.validate();
    }

    @Override
    public void start() {
        this.synth = JSyn.createSynthesizer();
        this.oscGain = new Multiply();
        this.synth.add(this.oscGain);
        this.oscGain.inputB.setup(0.02, 0.5, 1.0);
        this.oscGain.inputB.setName("Amplitude");
        this.freqRamp = new LinearRamp();
        this.synth.add(this.freqRamp);
        this.freqRamp.input.setup(50.0, 300.0, 20000.0);
        this.freqRamp.input.setName("Frequency");
        this.freqRamp.time.set(0.1);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.oscGain.output.connect(this.lineOut.input);
        this.setupGUI();
        this.buttonGroup = new ButtonGroup();
        this.addOscillator(new SineOscillator(), "Sine");
        this.addOscillator(new TriangleOscillator(), "Triangle");
        this.addOscillator(new SawtoothOscillator(), "Sawtooth");
        this.addOscillator(new SawtoothOscillatorBL(), "SawBL");
        this.addOscillator(new SawtoothOscillatorDPW(), "SawDPW");
        this.addOscillator(new RedNoise(), "RedNoise");
        this.addOscillator(new SquareOscillator(), "Square");
        this.addOscillator(new SquareOscillatorBL(), "SquareBL");
        this.addOscillator(new PulseOscillator(), "Pulse");
        this.addOscillator(new PulseOscillatorBL(), "PulseBL");
        this.addOscillator(new ImpulseOscillator(), "Impulse");
        this.addOscillator(new ImpulseOscillatorBL(), "ImpulseBL");
        this.synth.start();
        this.lineOut.start();
        this.lineOut.start();
    }

    private void addOscillator(final UnitOscillator osc, String label) {
        this.oscillators.add(osc);
        this.synth.add(osc);
        this.freqRamp.output.connect(osc.frequency);
        osc.amplitude.set(1.0);
        JRadioButton checkBox = new JRadioButton(label);
        this.buttonGroup.add(checkBox);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((SeeOscillators)SeeOscillators.this).oscGain.inputA.disconnectAll(0);
                osc.output.connect(((SeeOscillators)SeeOscillators.this).oscGain.inputA);
            }
        });
        this.oscPanel.add(checkBox);
    }

    @Override
    public void stop() {
        this.scope.stop();
        this.synth.stop();
    }
}

