/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.ports.QueueDataCommand;
import com.jsyn.ports.QueueDataEvent;
import com.jsyn.ports.UnitDataQueueCallback;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;

public class PlaySegmentedEnvelopeCallback {
    private Synthesizer synth;
    private UnitOscillator osc;
    private LineOut lineOut;
    private SegmentedEnvelope envelope;
    private VariableRateDataReader envelopePlayer;

    private void test() {
        this.synth = JSyn.createSynthesizer();
        this.osc = new SawtoothOscillatorBL();
        this.synth.add(this.osc);
        this.envelopePlayer = new VariableRateMonoReader();
        this.synth.add(this.envelopePlayer);
        double[] pairs = new double[]{0.1, 1.0, 0.2, 0.5, 0.6, 0.0};
        this.envelope = new SegmentedEnvelope(pairs);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.envelopePlayer.output.connect(this.osc.amplitude);
        this.osc.output.connect(0, this.lineOut.input, 0);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.synth.start();
        this.lineOut.start();
        try {
            QueueDataCommand command = this.envelopePlayer.dataQueue.createQueueDataCommand(this.envelope, 0, this.envelope.getNumFrames());
            TestQueueCallback callback = new TestQueueCallback();
            command.setCallback(callback);
            command.setNumLoops(2);
            this.envelopePlayer.rate.set(0.2);
            this.synth.queueCommand(command);
            this.synth.sleepFor(20.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.synth.stop();
    }

    public static void main(String[] args) {
        new PlaySegmentedEnvelopeCallback().test();
    }

    class TestQueueCallback
    implements UnitDataQueueCallback {
        TestQueueCallback() {
        }

        @Override
        public void started(QueueDataEvent event) {
            System.out.println("CALLBACK: Envelope started.");
        }

        @Override
        public void looped(QueueDataEvent event) {
            System.out.println("CALLBACK: Envelope looped.");
        }

        @Override
        public void finished(QueueDataEvent event) {
            System.out.println("CALLBACK: Envelope finished.");
            ((PlaySegmentedEnvelopeCallback)PlaySegmentedEnvelopeCallback.this).envelopePlayer.rate.set(2.0);
            ((PlaySegmentedEnvelopeCallback)PlaySegmentedEnvelopeCallback.this).envelopePlayer.dataQueue.queue(PlaySegmentedEnvelopeCallback.this.envelope);
        }
    }
}

