/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

public class MultiTable {
    public static final int NUM_TABLES = 8;
    public static final int CYCLE_SIZE = 1024;
    private static MultiTable instance = new MultiTable(8, 1024);
    private double phaseScalar;
    private float[][] tables;
    private static final double LOWEST_PHASE_INC_INV = 256.0;

    public MultiTable(int numTables, int cycleSize) {
        int tableSize = cycleSize + 1;
        this.tables = new float[numTables][tableSize];
        float[] sineTable = this.tables[0];
        this.phaseScalar = (float)((double)cycleSize * 0.5);
        int j = 0;
        while (j < tableSize) {
            sineTable[j] = (float)Math.sin((double)j / (double)cycleSize * Math.PI * 2.0 - Math.PI);
            ++j;
        }
        int i = 1;
        while (i < numTables) {
            float[] table = this.tables[i];
            int numPartials = 1 << i;
            double kGibbs = Math.PI / (double)(2 * numPartials);
            int k = 0;
            while (k < numPartials) {
                int sineIndex = 0;
                int partial = k + 1;
                double cGibbs = Math.cos((double)k * kGibbs);
                double ampl = cGibbs * cGibbs / (double)partial;
                int j2 = 0;
                while (j2 < tableSize) {
                    int n = j2;
                    table[n] = table[n] + (float)ampl * sineTable[sineIndex];
                    if ((sineIndex += partial) >= cycleSize) {
                        sineIndex -= cycleSize;
                    }
                    ++j2;
                }
                ++k;
            }
            ++i;
        }
        i = 1;
        while (i < numTables) {
            MultiTable.normalizeArray(this.tables[i]);
            ++i;
        }
    }

    public static float normalizeArray(float[] fdata) {
        float max = 0.0f;
        int i = 0;
        while (i < fdata.length) {
            float val = Math.abs(fdata[i]);
            if (val > max) {
                max = val;
            }
            ++i;
        }
        if (max < 1.0E-7f) {
            max = 1.0E-7f;
        }
        float gain = 1.0f / max;
        i = 0;
        while (i < fdata.length) {
            int n = i++;
            fdata[n] = fdata[n] * gain;
        }
        return gain;
    }

    public double calculateSawtooth(double currentPhase, double positivePhaseIncrement, double flevel) {
        double val;
        double findex = this.phaseScalar * currentPhase + this.phaseScalar;
        int sampleIndex = (int)findex;
        double horizontalFraction = findex - (double)sampleIndex;
        int tableIndex = (int)flevel;
        if (tableIndex > 6) {
            double fraction = positivePhaseIncrement * 256.0;
            float[] tableBase = this.tables[7];
            double sam1 = tableBase[sampleIndex];
            double sam2 = tableBase[sampleIndex + 1];
            double loSam = sam1 + horizontalFraction * (sam2 - sam1);
            val = currentPhase + fraction * (loSam - currentPhase);
        } else {
            double verticalFraction = flevel - (double)tableIndex;
            if (tableIndex < 0) {
                if (tableIndex < -1) {
                    val = 0.0;
                } else {
                    float[] tableBase = this.tables[0];
                    double sam1 = tableBase[sampleIndex];
                    double sam2 = tableBase[sampleIndex + 1];
                    double hiSam = sam1 + horizontalFraction * (sam2 - sam1);
                    val = verticalFraction * hiSam;
                }
            } else {
                float[] tableBase = this.tables[tableIndex + 1];
                double sam1 = tableBase[sampleIndex];
                double sam2 = tableBase[sampleIndex + 1];
                double hiSam = sam1 + horizontalFraction * (sam2 - sam1);
                tableBase = this.tables[tableIndex];
                sam1 = tableBase[sampleIndex];
                sam2 = tableBase[sampleIndex + 1];
                double loSam = sam1 + horizontalFraction * (sam2 - sam1);
                val = loSam + verticalFraction * (hiSam - loSam);
            }
        }
        return val;
    }

    public double convertPhaseIncrementToLevel(double positivePhaseIncrement) {
        if (positivePhaseIncrement < 1.0E-30) {
            positivePhaseIncrement = 1.0E-30;
        }
        return -1.0 - Math.log(positivePhaseIncrement) / Math.log(2.0);
    }

    public static MultiTable getInstance() {
        return instance;
    }
}

