/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.apps;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.JSynInstrumentLibrary;
import com.jsyn.swing.InstrumentBrowser;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PresetSelectionListener;
import com.jsyn.swing.SoundTweaker;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitSource;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.PolyphonicInstrument;
import com.jsyn.util.VoiceDescription;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JApplet;

public class InstrumentTester
extends JApplet {
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    private LineOut lineOut;
    private SoundTweaker tweaker;

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        InstrumentBrowser browser = new InstrumentBrowser(new JSynInstrumentLibrary());
        browser.addPresetSelectionListener(new PresetSelectionListener(){

            @Override
            public void presetSelected(VoiceDescription voiceDescription, int presetIndex) {
                UnitVoice[] voices = new UnitVoice[8];
                int i = 0;
                while (i < voices.length) {
                    voices[i] = voiceDescription.createUnitVoice();
                    ++i;
                }
                PolyphonicInstrument instrument = new PolyphonicInstrument(voices);
                InstrumentTester.this.synth.add(instrument);
                instrument.usePreset(presetIndex, InstrumentTester.this.synth.createTimeStamp());
                String title = String.valueOf(voiceDescription.getVoiceClassName()) + ": " + voiceDescription.getPresetNames()[presetIndex];
                InstrumentTester.this.useSource(instrument, title);
            }
        });
        this.add((Component)browser, "North");
        this.validate();
    }

    private void useSource(UnitSource voice, String title) {
        this.lineOut.input.disconnectAll(0);
        this.lineOut.input.disconnectAll(1);
        voice.getOutput().connect(0, this.lineOut.input, 0);
        voice.getOutput().connect(0, this.lineOut.input, 1);
        if (this.tweaker != null) {
            this.remove(this.tweaker);
        }
        try {
            if (this.synth.isRunning()) {
                this.synth.sleepFor(0.1);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.tweaker = new SoundTweaker(this.synth, title, voice);
        this.add((Component)this.tweaker, "Center");
        this.validate();
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.synth.stop();
    }

    public static void main(String[] args) {
        InstrumentTester applet = new InstrumentTester();
        JAppletFrame frame = new JAppletFrame("InstrumentTester", applet);
        frame.setSize(600, 800);
        frame.setVisible(true);
        frame.test();
    }
}

