/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AddUnit;
import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import java.util.Vector;

public class TJ_NRSineBenchmark {
    private static final int NUM_PAIRS = 300;
    private static final double AUDIO_TIME = 20.0;

    public static void main(String[] args) {
        TJ_NRSineBenchmark app = new TJ_NRSineBenchmark();
        app.test();
        System.exit(1);
    }

    public void test() {
        Vector<SineOscillator> sines = new Vector<SineOscillator>();
        Vector<AddUnit> adders = new Vector<AddUnit>();
        double MIN_FREQ = 200.0;
        double MAX_FREQ = 6000.0;
        double frequency = 200.0;
        try {
            Synth.startEngine(4);
            LineOut lineOut = new LineOut();
            MultiplyAddUnit scaler = new MultiplyAddUnit();
            lineOut.start();
            scaler.start();
            scaler.output.connect(0, lineOut.input, 0);
            scaler.output.connect(0, lineOut.input, 1);
            AddUnit lastAdder = null;
            int i = 0;
            while (i < 300) {
                SineOscillator sineOsc = new SineOscillator();
                sines.addElement(sineOsc);
                int numForScaling = i;
                if (numForScaling < 8) {
                    numForScaling = 8;
                }
                scaler.inputB.set(1.0 / (double)numForScaling);
                frequency *= 1.02;
                if (frequency > 6000.0) {
                    frequency = 200.0;
                }
                sineOsc.frequency.set(frequency);
                AddUnit adder = new AddUnit();
                adders.addElement(adder);
                if (lastAdder == null) {
                    adder.output.connect(scaler.inputA);
                } else {
                    adder.output.connect(lastAdder.inputA);
                }
                sineOsc.output.connect(adder.inputB);
                lastAdder = adder;
                adder.start();
                sineOsc.start();
                ++i;
            }
            long startTime = System.currentTimeMillis();
            Synth.sleepForTicks((int)(Synth.getTickRate() * 20.0));
            long endTime = System.currentTimeMillis();
            Synth.stopEngine();
            double realTime = (double)(endTime - startTime) / 1000.0;
            System.out.println("NUM_PAIRS = 300");
            System.out.println("real time = " + realTime);
            System.out.println("audio time = 20.0");
            System.out.println("real/audio = " + 100.0 * (realTime / 20.0) + "%");
        }
        catch (SynthException e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

