/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.LineOut;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SawtoothOscillatorBL;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOscillator;
import com.softsynth.jsyn.TriangleOscillator;
import com.softsynth.jsyn.view102.SynthScope;
import com.softsynth.tools.view.JAppletFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;

public class TJ_DebugBirds
extends JApplet {
    int numBirds;
    DebugCozumelBird[] birds;
    JButton[] buttons;
    LineOut unitOut;
    SynthScope scope;
    Dialog scopeDialog;
    SynthContext synthContext;

    public static void main(String[] args) {
        TJ_DebugBirds applet = new TJ_DebugBirds();
        JAppletFrame frame = new JAppletFrame("Birds", applet);
        frame.setSize(440, 200);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public String getAppletInfo() {
        return "(C) 1997 Phil Burk, updated 11/14/07";
    }

    @Override
    public void start() {
        this.getContentPane().setLayout(new GridLayout(0, 1));
        try {
            Synth.requestVersion(142);
            this.synthContext = new SynthContext();
            this.synthContext.startEngine(0);
            this.unitOut = new LineOut(this.synthContext);
            this.numBirds = 1;
            this.birds = new DebugCozumelBird[this.numBirds];
            this.buttons = new JButton[this.numBirds];
            int i = 0;
            while (i < this.numBirds) {
                this.birds[i] = new DebugCozumelBird(this.synthContext, 1000.0 + 4000.0 * (double)i / (double)(this.numBirds + 1));
                this.birds[i].unitOsc.output.connect(0, this.unitOut.input, 0);
                this.birds[i].start();
                this.buttons[i] = new JButton("Bird" + i);
                this.getContentPane().add(this.buttons[i]);
                this.buttons[i].addActionListener(new ChirpListener(this.birds[i]));
                ++i;
            }
            this.unitOut.start();
            this.scope = new SynthScope(this.synthContext, 4096);
            this.scope.createProbe(this.birds[0].unitLFO1.output, "LFO", Color.green);
            this.scope.createProbe(this.birds[0].unitOsc.output, "Osc", Color.blue);
            this.scope.finish();
            this.scopeDialog = new Dialog(SynthAlert.getFrame(this), "JSyn Scope");
            this.scopeDialog.add("Center", this.scope);
            this.scopeDialog.setBounds(200, 200, 600, 500);
            this.scopeDialog.show();
            this.getParent().validate();
            this.getToolkit().sync();
            this.unitOut.start();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    @Override
    public void stop() {
        this.scopeDialog.hide();
        this.removeAll();
        try {
            int i = 0;
            while (i < this.numBirds) {
                this.birds[i].delete();
                ++i;
            }
            this.unitOut.delete();
            this.synthContext.stopEngine();
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    class ChirpListener
    implements ActionListener {
        DebugCozumelBird bird;

        public ChirpListener(DebugCozumelBird bird) {
            this.bird = bird;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.bird.chirp();
            }
            catch (SynthException exc) {
                exc.printStackTrace();
            }
        }
    }

    class DebugCozumelBird
    extends SynthCircuit {
        TriangleOscillator unitOsc;
        SynthOscillator unitLFO1;
        MultiplyAddUnit unitFreqMix;
        double topFreq;

        public DebugCozumelBird(SynthContext synthContext, double topFreq) throws SynthException {
            super(synthContext);
            this.topFreq = topFreq;
            this.unitOsc = new TriangleOscillator(synthContext);
            this.add(this.unitOsc);
            this.unitLFO1 = new SawtoothOscillatorBL(synthContext);
            this.add(this.unitLFO1);
            this.unitFreqMix = new MultiplyAddUnit(synthContext);
            this.add(this.unitFreqMix);
            this.unitFreqMix.inputB.set(200.0);
            this.unitFreqMix.inputC.set(300.0);
            this.unitOsc.amplitude.set(0.2);
            this.unitLFO1.output.connect(this.unitFreqMix.inputA);
            this.unitFreqMix.output.connect(this.unitOsc.frequency);
            this.compile();
        }

        public void chirp() throws SynthException {
            int dur = 200;
            int ticks = this.getSynthContext().getTickCount();
            System.out.println("ticks = " + ticks);
            int i = 0;
            while (i < 6) {
                this.unitLFO1.frequency.set(ticks, 50.0 * (Math.random() * (Math.random() - 0.5)));
                ticks = (int)((double)ticks + (double)dur * (Math.random() + 0.5));
                ++i;
            }
        }
    }
}

