/*
 * Decompiled with CFR 0.152.
 */
package JSynTests;

import com.softsynth.jsyn.AppletFrame;
import com.softsynth.jsyn.AudioDevice;
import com.softsynth.jsyn.ChannelIn;
import com.softsynth.jsyn.ChannelOut;
import com.softsynth.jsyn.SineOscillator;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthUnit;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GridLayout;

public class DebugDevices
extends Applet
implements Runnable {
    SynthContext synthContext;
    ChannelIn[] inputs;
    ChannelOut[] outputs;
    SineOscillator[] sines;
    int numOutputChannels = 2;
    Thread thread;
    volatile boolean go = false;

    public static void main(String[] args) {
        DebugDevices applet = new DebugDevices();
        AppletFrame frame = new AppletFrame("Test JSyn Devices", applet);
        frame.resize(600, 300);
        frame.show();
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new GridLayout(0, 1));
        Synth.requestVersion(142);
        this.synthContext = new SynthContext();
        this.synthContext.initialize();
        this.thread = new Thread(this);
        this.go = true;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.startAudio();
        Thread thread = this.thread;
        synchronized (thread) {
            while (this.go) {
                try {
                    this.thread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.stopAudio();
    }

    void startAudio() {
        try {
            int inDevID = AudioDevice.getDefaultInputDeviceID();
            System.out.println("Default input = " + inDevID);
            int outDevID = AudioDevice.getDefaultOutputDeviceID();
            System.out.println("Default output = " + outDevID);
            this.synthContext.start(0, 44100.0, inDevID, 2, outDevID, this.numOutputChannels);
            int numOut = this.numOutputChannels;
            if (numOut > 0) {
                this.outputs = new ChannelOut[numOut];
                this.sines = new SineOscillator[numOut];
                int i = 0;
                while (i < numOut) {
                    this.outputs[i] = new ChannelOut(this.synthContext, i);
                    this.outputs[i].start();
                    this.sines[i] = new SineOscillator(this.synthContext);
                    this.sines[i].frequency.set(500.0 * (double)(i + 1));
                    this.sines[i].amplitude.set(1.0);
                    this.sines[i].start();
                    this.sines[i].output.connect(this.outputs[i].input);
                    ++i;
                }
            }
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            Thread thread = this.thread;
            synchronized (thread) {
                this.go = false;
                this.thread.notifyAll();
            }
            try {
                this.thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.synthContext.delete();
        }
        catch (SynthException e) {
            SynthAlert.showError((Component)this, e);
        }
    }

    void killUnits(SynthUnit[] units) {
        if (units != null) {
            int i = 0;
            while (i < units.length) {
                units[i].stop();
                units[i].delete();
                ++i;
            }
        }
    }

    void stopAudio() {
        this.killUnits(this.outputs);
        this.outputs = null;
        this.killUnits(this.inputs);
        this.inputs = null;
        this.killUnits(this.sines);
        this.sines = null;
        this.synthContext.stop();
        this.getParent().validate();
        this.getToolkit().sync();
    }
}

